% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_nca_run}
\alias{system_nca_run}
\title{Automatic NCA}
\usage{
system_nca_run(
  cfg,
  dsname = "PKDS",
  dscale = 1,
  NCA_min = 4,
  analysis_name = "analysis",
  dsfilter = NULL,
  extrap_C0 = TRUE,
  extrap_N = 2,
  sparse = FALSE,
  dsmap = list(TIME = "TIME", NTIME = "NTIME", CONC = "CONC", DOSE = "DOSE", ID = "ID",
    ROUTE = "ROUTE", DOSENUM = NULL, BACKEXTRAP = NULL, SPARSEGROUP = NULL),
  digits = 3,
  dsinc = NULL
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{dsname}{name of dataset loaded with (\code{\link{system_load_data}})}

\item{dscale}{factor to multiply the dose to get it into the same units as concentration (default \code{1}):
if you are dosing in mg/kg and your concentrations is in ng/ml, then \code{dscale = 1e6}}

\item{NCA_min}{minimum number of points required to perform NCA for a given subset (default \code{4})}

\item{analysis_name}{string containing the name of the analysis (default 'analysis') to archive to files and reference results later}

\item{dsfilter}{list of names corresponding to the column names in the dataset and values are a sequence indicating values to keep (default \code{NULL}. Multiple names are and-ed together. For example the following would keep all of the records where dose is 1, 2, or 5 and the dose_number is 1
\preformatted{
 dsfilter = list(dose=c(1,2,5), dose_number = c(1))
}}

\item{extrap_C0}{Boolean variable to enable automatic determination of initial drug concentration if no value is specified; the rules used by WinNonlin will be used: 
\itemize{
  \item If the route is \code{"iv infusion"} or \code{"extra-vascular"} and the data is single dose data, then a concentration of zero will be used. If repeat dosing is used, the minimum value from the previous dosing interval will be used.
  \item If the route is \code{"iv bolus"} then log-linear regression of the number of observations specified by \code{extrap_N} will be used. If the slope of these points is positive the first positive observation will be used as an estimate of C0
}}

\item{extrap_N}{number of points to use for back extrapolation (default \code{2}); this number can be overwritten for each subject using the \code{BACKEXTRAP} column in the dataset}

\item{sparse}{Boolean variable used to indicate data used sparse sampling and the analysis should use the average at each time point (the \code{SPARSEGROUP} column must be specified in the \code{dsmap} below)}

\item{dsmap}{list with names specifying the columns in the dataset (* required): 
\itemize{
 \item \code{TIME}*       Time since the first dose; \code{"TIME"} (default)
 \item \code{NTIME}*      Nominal time since last dose;  \code{"NTIME"} (default)
 \item \code{CONC}*       Concentration data;  \code{"CONC"} (default)
 \item \code{DOSE}*       Dose given;  (\code{"DOSE"} (default)
 \item \code{ID}*         Subject ID;  (\code{"ID"} (default)
 \item \code{ROUTE}*      Route of administration;  \code{"ROUTE"} (default), can be either \code{"iv bolus"}, \code{"iv infusion"} or \code{"extra-vascular"} 
 \item \code{DOSENUM}     Numeric dose (starting at 1) used for grouping multiple dose data; optional, \code{NULL} (default) for single dose data)
 \item \code{BACKEXTRAP}  Specifying the number of points to use to extrapolate the initial concentration for "iv bolus" dosing; optoinal f \code{NULL} (default) will use the value defined in \code{extrap_N} (note this value must be <= NCA_min)
 \item \code{SPARSEGROUP} Column containing a unique value grouping cohorts for pooling data. Needed when \code{sparse} is set to \code{TRUE}; optional, \code{NULL} (default)
}}

\item{digits}{number of significant digits to report \code{3} (default), set to \code{NULL} to disable rounding}

\item{dsinc}{(NOT CURRENTLY IMPLEMENTED) optional character vector of columns from the dataset to include in the output summary (default \code{NULL})}
}
\value{
cfg ubiquity system object with the NCA results and if the analysis name is specified:
\itemize{
    \item{output/{analysis_name}-nca_summary-pknca.csv} NCA summary 
    \item{output/{analysis_name}-pknca_summary.csv} Raw output from PKNCA with subject and dose number columns appended 
    \item{output/{analysis_name}-nca_data.RData} objects containing the NCA summary and a list with the ggplot grobs
}
}
\description{
Performs NCA in an automated fashion
}
\seealso{
Vignette on NCA (\code{vignette("NCA", package = "ubiquity")})
}
