% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcount.R
\name{stan_pcount}
\alias{stan_pcount}
\title{Fit the N-mixture model of Royle (2004)}
\usage{
stan_pcount(formula, data, K = NULL, mixture = "P", ...)
}
\arguments{
\item{formula}{Double right-hand side formula describing covariates of
detection and abundance in that order}

\item{data}{A \code{\link{unmarkedFramePCount}} object}

\item{K}{Integer upper index of integration for N-mixture. This should be
set high enough so that it does not affect the parameter estimates.
Note that computation time will increase with K.}

\item{mixture}{Character specifying mixture: "P" is only option currently.}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitPcount} object describing the model fit.
}
\description{
This function fits the single season N-mixture model of
Royle et al. (2004).
}
\examples{
\donttest{
data(mallard)
mallardUMF <- unmarkedFramePCount(mallard.y, siteCovs=mallard.site)

(fm_mallard <- stan_pcount(~1~elev+forest, mallardUMF, K=30,
                           chains=3, iter=300))
}

}
\references{
Royle JA. 2004. N-mixture models for estimating populaiton size
 from spatially replicated counts. Biometrics 60: 105-108.
}
\seealso{
\code{\link{pcount}}, \code{\link{unmarkedFramePCount}}
}
