% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_silent}
\alias{umx_set_silent}
\title{Turn off most console and summary output from umx}
\usage{
umx_set_silent(value = NA, silent = FALSE)
}
\arguments{
\item{value}{Boolean stating if umx Models should run silently (TRUE).}

\item{silent}{If TRUE, this function itself will just return the state of the option, with no user message.}
}
\value{
\itemize{
\item Current silent value
}
}
\description{
Running multiple analyses or simulations, it can be handy to turn off the automatic summary,
graphing, and printing that umx does to help interactive sessions. \code{umx_set_silent} does this.
Summary and graph output, as well as progress and durable console output will be suppressed.
}
\details{
Not every function knows about silent, but most, like \code{\link[=umxRAM]{umxRAM()}} etc do.

Under the hood, \code{umx_set_silent} sets options("umx_silent"). This can be set to either \code{TRUE} or \code{FALSE}.
If TRUE, then the progress messages from model runs are suppressed. Useful for power simulations etc.
}
\examples{
library(umx)
old = umx_set_silent() # print & store existing value
umx_set_silent(FALSE, silent = TRUE) # set to FALSE
umx_set_silent(old)   # reinstate
umx_set_silent() # print existing value
}
\references{
\itemize{
\item \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_plot_use_hrbrthemes}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_table_format}()},
\code{\link{umx}}
}
\concept{Get and set}
