% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_optimization_options}
\alias{umx_set_optimization_options}
\title{Set options that affect optimization in OpenMx}
\usage{
umx_set_optimization_options(
  opt = c("mvnRelEps", "mvnMaxPointsA", "Parallel diagnostics"),
  value = NULL,
  model = NULL,
  silent = FALSE
)
}
\arguments{
\item{opt}{default returns current values of the options listed. Currently
"mvnRelEps", "mvnMaxPointsA", and "Parallel diagnostics".}

\item{value}{If not NULL, the value to set the opt to (can be a list of length(opt))}

\item{model}{A model for which to set the optimizer. Default (NULL) sets the optimizer globally.}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
\itemize{
\item current values if no value set.
}
}
\description{
\code{umx_set_optimization_options} provides access to get and set options affecting optimization.
}
\details{
\emph{note}: For \code{mvnRelEps}, values between .0001 to .01 are conventional. Smaller values slow optimization.
}
\examples{
# show current value for selected or all options
umx_set_optimization_options() # print the existing state(s)
umx_set_optimization_options("mvnRelEps") 
\dontrun{
umx_set_optimization_options("mvnRelEps", .01) # update globally
umx_set_optimization_options("Parallel diagnostics", value = "Yes") 
}
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx}},
\code{\link{umx_get_alphas}()},
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_silent}()},
\code{\link{umx_set_table_format}()}
}
\concept{Get and set}
