% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneAnno.R
\docType{methods}
\name{getNihSummary}
\alias{getNihSummary}
\alias{getNihSummary,gene-method}
\title{Gather NIH Gene Data}
\usage{
getNihSummary(x, y)

\S4method{getNihSummary}{gene}(x, y)
}
\arguments{
\item{x}{\code{gene} object}

\item{y}{\code{query} object (see \code{getNihQuery()})}
}
\value{
\code{gene} object a copy of the input object 'x', having the uniprot data added.
}
\description{
\code{getNihSummary} collates data returned from a html request to the NCBI publicly available gene database to populate the gene object.
Accessing the NCBI NIH databases is a two stage process; the \code{getNihSummary} function
carries out the second stage in relation to the NCBI "gene" database, populating NIH specific slots in a \code{gene} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{gene}: \code{gene} object a copy of the input object 'x', having the uniprot data added.
}}
\examples{
\dontrun{
f <- query()
f@gene <- "BRAF"
db <- "gene"
f <- getNihQuery(f,db,f@gene)
gene <- getNihSummary(gene(),f)
}
}

