% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Newfoundland.R
\docType{data}
\name{mun_2}
\alias{mun_2}
\title{Secondary Colors of the University Memorial University of Newfoundland, Canada}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on the
\href{https://www.mun.ca/marcomm/media/production/memorial/administrative/marcomm/files/BrandStandards_August_2017_FA.pdf}{Brand standard manual (PDF)}.
}
\usage{
mun_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{mun_2} provides the 12 secondary colors 
of the \href{https://www.mun.ca/}{Memorial University of Newfoundland} (MUN), Canada.
}
\details{
The 12 secondary colors of MUN are
\code{"rodamine_red"} (defined as RGB 225/0/152, HEX #E10098),
\code{"PMS_185"} (defined as RGB 228/0/43, HEX #E4002B),
\code{"orange_021"} (defined as RGB 254/80/0, HEX #FE5000),
\code{"PMS_1235"} (defined as RGB 255/184/28, HEX #FFB81C),
\code{"yellow_mun"} (defined as RGB 255/221/0, HEX #FEDD00),
\code{"PMS_396"} (defined as RGB 225/224/0, HEX #E1E000),
\code{"PMS_368"} (defined as RGB 120/190/32, HEX #78BE20),
\code{"PMS_3275"} (defined as RGB 0/179/152, HEX #00B398),
\code{"PMS_3125"} (defined as RGB 0/174/199, HEX #00AEC7),
\code{"PMS_2727"} (defined as RGB 48/127/226, HEX #307FE2),
\code{"PMS_2736"} (defined as RGB 48/127/170, HEX #1E22AA), and
\code{"purple_mun"} (defined as RGB 187/41/187, HEX #BB29BB).

\code{mun_2} uses the HEX color definitions. 

The RGB and HEX definitions differ numerically for the \code{"PMS_2736"} , 
yet are visually indistinguishable. Our color palette is based on the HEX definition.
}
\examples{
mun_2
unikn::seecol(mun_1, 
              main = "Memorial University of Newfoundland 2") # view color palette

}
\seealso{
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-12-07.
}
\concept{Canadian university color palettes}
\keyword{datasets}
