% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCalgary.R
\docType{data}
\name{ucalgary_1}
\alias{ucalgary_1}
\title{Primary colours of the University of Calgary, Canada}
\format{
An object of class \code{character} of length 2.
}
\source{
Colour definitions are based on UCalgary's 
\href{https://www.ucalgary.ca/sites/default/files/teams/12/3.0-eyes-high-dec2018.pdf}{Visual Identity Standards}.
}
\usage{
ucalgary_1
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{ucalgary_1} provides the two primary colours 
of \href{https://www.ucalgary.ca/}{University of Calgary}, Canada.
}
\details{
The two primary colours are
\code{"red"} (defined as HEX #cf0722) and
\code{"gold"} (defined as HEX #ffcd00).
}
\examples{
ucalgary_1
unikn::seecol(ucalgary_1, main = "Primary colours UCalgary") # view colour palette

}
\seealso{
\code{\link{ucalgary_2}} for the secondary colours of the University of Calgary;
\code{\link{ucalgary_warmgreys}} for the warm grey colours of the University of Calgary;
\code{\link{ucalgary_accent}} for the accent colours of the University of Calgary;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{conc_1}},
\code{\link{conc_2}},
\code{\link{conc_3}},
\code{\link{conc_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_complementary}},
\code{\link{uvic_core}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Canadian university color palettes}
\keyword{datasets}
