% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Queens_University.R
\docType{data}
\name{queensu_2}
\alias{queensu_2}
\title{Secondary colours of Queen's University, Canada}
\format{
An object of class \code{character} of length 11.
}
\source{
Colour definitions are based on the
\href{https://www.queensu.ca/brand-central/visual-identity/colours}{Visual Identity}.
}
\usage{
queensu_2
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{queensu_2} provides the secondary colours 
of \href{https://www.queensu.ca/}{Queen's University}, Canada.
}
\details{
A secondary palette of neutral colours may be used with the primary palette to provide balance.

The three primary colours are
\code{"white"} (defined as CMYK 0/0/0/0, RGB 255/255/255, HEX #ffffff),
\code{"lightest_grey"} (defined as CMYK 0/0/0/5, RGB 241/242/242, HEX #f1f2f2),
\code{"light_grey"} (defined as CMYK 0/0/0/10, RGB 230/231/232, HEX #e6e7e8),
\code{"grey"} (defined as CMYK 0/0/0/20, RGB 209/211/212, HEX #d1d3d4),
\code{"medium_grey"} (defined as CMYK 0/0/0/40, RGB 167/169/172, HEX #a7a9ac),
\code{"dark_grey"} (defined as CMYK 0/0/0/60, RGB 128/130/133, HEX #808285),
\code{"darkest_grey"} (defined as CMYK 0/0/0/80, RGB 88/89/91, HEX #58595b),
\code{"black"} (defined as CMYK 0/0/0/100, RGB 33/33/33, HEX #212121),
\code{"light_limestone"} (defined as PMS 401, CMYK 28/25/28/3, RGB 180/174/168, HEX #b3aea8),
\code{"limestone"} (defined as PMS 403 CMYK 39/36/40/14, RGB 144/137/130, HEX #908982), and
\code{"dark_limestone"} (defined as PMS 405, CMYK 49/47/51/32, RGB 106/98/92, HEX #6a625c).

\code{queensu_2} uses the HEX colour definition. 
PMS and CMYK colours differ from RGB and HEX definition.
}
\examples{
queensu_2
unikn::seecol(queensu_2, 
              main = "Secondary colours of Queen's University") # view colour palette

}
\seealso{
\code{\link{queensu_1}} for the primary colours of Queen's University;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-28.
}
\concept{Canadian university color palettes}
\keyword{datasets}
