% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate.R
\name{testthat_translate_file}
\alias{testthat_translate_file}
\alias{testthat_translate_name}
\alias{testthat_translate_dir}
\title{Convert a \code{testthat} Test File to a \code{unitizer}}
\usage{
testthat_translate_file(file.name,
  target.dir = file.path(dirname(file.name), "..", "unitizer"),
  state = getOption("unitizer.state"), keep.testthat.call = TRUE,
  prompt = "always", interactive.mode = interactive(), ...)

testthat_translate_dir(dir.name, target.dir = file.path(dir.name, "..",
  "unitizer"), filter = "^test.*\\\\.[rR]",
  state = getOption("unitizer.state"), keep.testthat.call = TRUE,
  force = FALSE, interactive.mode = interactive(), ...)

testthat_translate_name(file.name,
  target.dir = file.path(dirname(file.name), "..", "unitizer"),
  name.new = NULL, name.pattern = "^(?:test\\\\W*)?(.*)(?:\\\\.[rR])$",
  name.replace = "\\\\1")
}
\arguments{
\item{file.name}{a path to the \code{testthat} test file to convert}

\item{target.dir}{the directory to create the \code{unitizer} test file and
test store in; for \code{testthat_translate_file} only: if NULL will return
as a character vector what the contents of the translated file would have
been instead of writing the file}

\item{state}{what state control to use (see same argument for
\code{\link{unitize}})}

\item{keep.testthat.call}{whether to preserve the \code{testthat} call that
was converted, as a comment}

\item{prompt}{character(1L): \itemize{
  \item "always" to always prompt before writing new files
  \item "overwrite" only prompt if existing file is about to be overwritten
  \item "never" never prompt
}}

\item{interactive.mode}{logical(1L) primarily for testing purposes, allows
us to force prompting in non-interactive mode; note that \code{unitize}
and \code{unitize_dir} are always called in non-interactive mode by these
functions, this parameter only controls prompts generated directly by these
functions.}

\item{...}{params to pass on to \code{testthat_translate_name}}

\item{dir.name}{a path to the \code{testthat} directory to convert}

\item{filter}{regular expression to select what files in a director are
translated}

\item{force}{logical(1L) whether to allow writing to a \code{target.dir} that
contains files (implies \code{prompt="never"} when
\code{testthat_translate_dir} runs \code{testthat_translate_file})}

\item{name.new}{character(1L) the base name for the \code{unitizer} files;
do not include an extension as we will add it (".R" for the testfile,
".unitizer" for the data directory); set to NULL to generate the name
from the \code{testthat} file name}

\item{name.pattern}{character(1L) a regular expression intended to match
the \code{testthat} test file name (see \code{name.replace}) if
\code{name.pattern} matches, then the new file name will be
constructed with this (used as \code{replace} parameter to
\code{\link{sub}}); in addition we will add ".R" and ".unitizer" as the
extensions for the new files so do not include extensions in your
\code{name.replace} parameter}

\item{name.replace}{character(1L) the replacement token, typically would
include a \code{"\\1"} token that is filled in by the match group from
\code{name.pattern}}
}
\value{
a file path or a character vector (see \code{target.dir})
}
\description{
Converts a \bold{copy} of an existing \code{testthat} test file to a
\code{unitizer} test file and test store, or a directory of such files to
a corresponding \code{unitizer} directory.  See examples.
}
\note{
In order for the conversion to succeed \code{testthat} must be
installed on your system.  We do not rely on \code{NAMESPACE} imports to
avoid an import dependency on \code{testthat} that is only required for these
ancillary functions, especially since none of the \code{testthat} functions
are called.  We use the functions as the \code{definition} argument of
\code{match.call} to find the \code{object} argument.

Translation of \code{testthat} is not strictly necessary; you can just
copy them to a new location and \code{unitize} them.  \code{unitizer} will
just capture the results of the \code{expect_*} functions and will alert
you if those change.  You can then just review the tests that change.
While this may seem pointless, one benefit is that you are dropped into
the environment of the test that failed, so you can inspect variables, etc.
without further ado.
}
\section{Disclaimers}{


If you already have an extensive test suite in \code{testthat} and you do not
intend to modify your tests or code very much there is little benefit (and
likely some drawbacks) to migrating your tests to \code{unitizer}.  Please
see the introduction vignette for a (biased) view of the pros and cons of
\code{unitizer} relative to \code{testthat}.

These translation functions are provided for your convenience.  The
\code{unitizer} author does not use them very much since he seldom needs to
migrate \code{testthat} tests.  As a result, they have not been tested as
thoroughly as the rest of \code{unitizer}.  Translation is designed to work
for the most common \code{testthat} use cases, but may not for yours.  Make
sure you \code{\link{review}} the resulting \code{unitizer}s to make sure
they contain what you expect before you start relying on them.  This is
particularly important if your \code{testthat} test files are not meant to
be run stand-alone with just \code{test_file} (see "Differences That May
Cause Problems").

Note you can also \code{unitize} your \code{testthat} files \bold{without}
translating them (see notes).
}

\section{Workflow}{


\enumerate{
  \item Start a fresh R session
  \item Run your \code{testthat} tests with \code{test_dir} to
    ensure they are still passing.  If your tests are are runnable only
    via \code{test_check} because they directly access the namespace of your
    package, see "Differences That May Cause Problems" below
  \item Run \code{testthat_dir_translate}
  \item [optional] use \code{\link{review}} to review the resulting
     unitizer(s)
}
We recommend using \code{testthat_translate_dir} over
\code{testthat_translate_file} because the former also copies and loads any
helper files that may be defined.  Since libraries used by multiple test
files are commonly loaded in these helper files, it is likely that just
translating a single file without also copying the helper files will not
work properly.
}

\section{How the Conversion Works}{


We start by identifying calls to exported \code{testthat} functions
that have an \code{object} argument.  Generally speaking this includes
functions of the form \code{expect_*} (e.g. \code{expect_equal}).  We then
extract the \code{object} parameter and replace the original \code{expect_*}
statement with just the \code{object} parameter.  For example
\preformatted{expect_equal(my_fun(25), 1:10)}
becomes
\preformatted{my_fun(25)}
Not all \code{expect_*} functions are substituted.  For example,
\code{expect_is} and \code{expect_that} are left unchanged because the tests
for those functions do not or might not actually test the values of
\code{object}.  For example, \code{expect_is} tests the \bold{class} of
\code{object}.  It is perfectly fine to \code{unitize} an \code{expect_*}
call unsubstituted.  \code{unitizer} captures conditions, values, etc., so if
an \code{expect_*} test starts failing, it will be detected.

\code{unitizer} will then evaluate and store the results of such expressions.
Since in theory we just checked our \code{testthat} tests were working,
presumably the re-evaluated expressions will produce the same values.  Please
note that the translation process does not actually check this is true (see
"Differences That May Cause Problems") so \code{review}ing the results is a
good idea.

\code{test_that} calls are converted to \code{\link{unitizer_sect}} calls,
and the contents thereof are processed as described above.  Calls to
\code{context} are commented out since there currently is no \code{unitizer}
equivalent.  Other \code{testthat} calls are left unchanged and their return
values used as part of the \code{unitizer} tests.

Only top level calls are converted.  For example, code like
\code{for(i in 1:10) expect_equal(my_fun(i), seq(i))} or even
\code{(expect_equal(my_fun(10), 1:10))} will not be converted since
\code{expect_equal} is nested inside a \code{for} and \code{(} respectively.
You will need to manually edit these calls (or just let them remain as is,
which is not an issue).

We identify calls to extract based purely on the function symbols (i.e. we
do not check whether \code{expect_equal} actually resolves to
\code{testthat::expect_equal} in the context of the test file).

The \code{unitizer} files will be created in a sibling folder to the folder
containing the \code{testthat} files.  The names of the new files will be
based on the old files.  See params \code{target.dir}, \code{name.new},
\code{name.pattern}, and \code{name.replace} for more details.  We encourage
you to try the default settings first as those should work well in most
cases.

When using \code{testthat_translate_dir}, any files that match
\code{"^helper.*[rR]$"} are copied over to a '/_pre' subdirectory
in \code{"target.dir"}, and are pre-loaded by default before the tests are
\code{unitize}d.
}

\section{\code{unitizer} Differences That May Cause Problems}{


If you run your tests during development with \code{test_dir} odds
are the translation will work just fine.  On the other hand, if you rely
exclusively on \code{test_check} you may need to use
\code{state=unitizerStateNoOpt(par.env="pkgName")} when you translate to
make sure your tests have access to the internal namespace functions.
See \code{\link{unitizerState}} for details on how to modify state tracking.

If your tests were translated with the \code{state} parameter changed from
its default value, you will have to use the same value for that parameter in
future \code{unitize} or \code{unitize_dir} runs.
}

\examples{
\dontrun{
library(testthat)  # required
testthat_translate_file("tests/testthat/test-random.R")

# Translate `dplyr` tests (assumes `dplyr` source is in './dplyr')
# Normally we would use default `state` value but we cannot in this case
# due to conflicting packages and setup

testthat_translate_dir(
  "dplyr/tests/testthat", state=unitizerStateSafe(par.env="dplyr")
)
# Make sure translation worked (checking one file here)
# *NOTE*: folder we are looking at has changed

review("dplyr/tests/unitizer/summarise.unitizer")

# Now we can unitize any time we change our code

unitize_dir(
  "dplyr/tests/unitizer", state=unitizerStateSafe(par.env="dplyr")
)
}
}
\seealso{
\code{\link{unitize}}, \code{\link{unitizerState}}
}
