% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_select.R
\name{model_select}
\alias{model_select}
\title{Fit multiple models and select the best fit}
\usage{
model_select(
  x,
  models = univariateML_models,
  criterion = c("aic", "bic", "loglik"),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{models}{a character vector containing the distribution models to
select from; see \code{print(univariateML_models)}.}

\item{criterion}{the model selection criterion. Must be one of \code{"aic"},
\code{"bic"}, and \code{"loglik"}.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{unused.}
}
\value{
\code{model_select} returns an object of \link[base:class]{class}
\code{univariateML}. This is a named numeric vector with maximum likelihood
estimates for the parameters of the best fitting model and the following
attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
Selects the best model by log-likelihood, AIC, or BIC.
}
\examples{
model_select(precip)
}
\seealso{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate
Distributions, Volume 1, Chapter 17. Wiley, New York.
}
