% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.r
\name{cart2pol}
\alias{cart2pol}
\title{cart2pol}
\usage{
cart2pol(x, y, degrees = FALSE)
}
\arguments{
\item{x}{The x-coordinate of the point}

\item{y}{The y-coordinate of the point}

\item{degrees}{Logical indicating if theta should be returned in degrees}
}
\value{
A data.frame holding the polar coordinates and the original (x,y) coordinates
}
\description{
Converts polar coordinates to caretsian coordinates
}
\details{
Converts polar coordinates to caretsian coordinates using a simple conversion.  The angle, \code{theta} must be in radians.

Somewhat inspired by http://www.r-bloggers.com/convert-polar-coordinates-to-cartesian/ and https://www.mathsisfun.com/polar-cartesian-coordinates.html
}
\examples{

library(dplyr)
x1 <- c(1, sqrt(3)/2, sqrt(2)/2, 1/2, 0)
y1 <- c(0, 1/2, sqrt(2)/2, sqrt(3)/2, 1)
d1 <- data_frame(x=x1, y=y1, Q='I')

x2 <- c(0, -1/2, -sqrt(2)/2, -sqrt(3)/2, -1)
y2 <- c(1, sqrt(3)/2, sqrt(2)/2, 1/2, 0)
d2 <- data_frame(x=x2, y=y2, Q='II')

x3 <- c(-1, -sqrt(3)/2, -sqrt(2)/2, -1/2, 0)
y3 <- c(0, -1/2, -sqrt(2)/2, -sqrt(3)/2, -1)
d3 <- data_frame(x=x3, y=y3, Q='III')

x4 <- c(0, 1/2, sqrt(2)/2, sqrt(3)/2, 1)
y4 <- c(-1, -sqrt(3)/2, -sqrt(2)/2, -1/2, 0)
d4 <- data_frame(x=x4, y=y4, Q='IV')

dAll <- bind_rows(d1, d2, d3, d4)

cart2pol(dAll$x, dAll$y)
cart2pol(dAll$x, dAll$y, degrees=TRUE)

}
\author{
Jared P. Lander
}

