% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible.R
\name{is_infeasible}
\alias{is_infeasible}
\title{Check the feasibility of a rule set}
\usage{
is_infeasible(x, ...)
}
\arguments{
\item{x}{\code{validator} object with validation rules.}

\item{...}{not used}
}
\value{
TRUE or FALSE
}
\description{
An infeasible rule set cannot be satisfied by any data because of internal 
contradictions. This function checks whether the record-wise linear,
categorical and conditional rules in a rule set are consistent.
}
\examples{
rules <- validator( x > 0)

is_infeasible(rules)

rules <- validator( rule1 = x > 0
                  , rule2 = x < 0
                  )

is_infeasible(rules)

detect_infeasible_rules(rules)
make_feasible(rules)

# find out the conflict with this rule
is_contradicted_by(rules, "rule1")
}
\seealso{
Other feasibility: 
\code{\link{detect_boundary_cat}()},
\code{\link{detect_boundary_num}()},
\code{\link{detect_infeasible_rules}()},
\code{\link{is_contradicted_by}()},
\code{\link{make_feasible}()}
}
\concept{feasibility}
