% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redundancy.R
\name{remove_redundancy}
\alias{remove_redundancy}
\title{Remove redundant rules}
\usage{
remove_redundancy(x, ...)
}
\arguments{
\item{x}{\code{\link{validator}} object with validation rules.}

\item{...}{not used}
}
\value{
simplified \code{\link{validator}} object, in which redundant rules are removed.
}
\description{
Simplify a rule set by removing redundant rules
}
\examples{
rules <- validator( rule1 = x > 1
                  , rule2 = x > 2
                  )

# rule1 is superfluous
remove_redundancy(rules)

# rule 1 is implied by rule 2
is_implied_by(rules, "rule1")

rules <- validator( rule1 = x > 2
                  , rule2 = x > 2
)

# standout: rule1 and rule2, oldest rules wins
remove_redundancy(rules)

# Note that detection signifies both rules!
detect_redundancy(rules)


}
\seealso{
Other redundancy: 
\code{\link{detect_fixed_variables}()},
\code{\link{detect_redundancy}()},
\code{\link{is_implied_by}()},
\code{\link{simplify_fixed_variables}()},
\code{\link{simplify_rules}()}
}
\concept{redundancy}
