% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_genome.r
\name{read_genome}
\alias{read_genome}
\title{Read genome files.}
\usage{
read_genome(path)
}
\arguments{
\item{path}{containing chrom/contig names and sizes, one-pair-per-line,
tab-delimited}
}
\value{
\code{\link[=tbl_genome]{tbl_genome()}}, sorted by \code{size}
}
\description{
Genome files (UCSC "chromSize" files) contain chromosome name and size
information. These sizes are used by downstream functions to identify
computed intervals that have coordinates outside of the genome bounds.
}
\note{
URLs to genome files can also be used.
}
\examples{
read_genome(valr_example('hg19.chrom.sizes.gz'))

\dontrun{
# `read_genome` accepts a URL
read_genome('https://genome.ucsc.edu/goldenpath/help/hg19.chrom.sizes')
}

}
\seealso{
Other read functions: \code{\link{read_bed}},
  \code{\link{read_vcf}}
}
