% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ConservationPlot}
\alias{ConservationPlot}
\title{Conservation Plot (Number of Waters Per Cluster Histogram)}
\usage{
ConservationPlot(data, passed.waters = TRUE)
}
\arguments{
\item{data}{The \code{h2o.clusters.summary} data.frame from the
\code{\link[=ClusterWaters]{ClusterWaters()}} function containing the \code{num.waters} information.
The \code{num.waters} values are integers.}

\item{passed.waters}{Logical indicator to plot results for waters \strong{passing}
\code{\link[=Mobility]{Mobility()}} and \code{\link[=NormalizedBvalue]{NormalizedBvalue()}} \emph{\strong{OR}} using \strong{all} waters within
the \code{PDB} files.}
}
\description{
Histogram and density plots for number of cluster with number of
atoms
}
\details{
Constructs a histogram for the number of waters per cluster.
Clusters with less than 50\% conservation are light grey, clusters with 50
to 69\% water conseration are dark red, clusters with 70 to 79\%
conservation are red, 80 to 89\% conservation are light blue, 90 to 99\%
conservation are blue, and 100\% conservation (waters from all structures)
are dark blue.
}
\examples{
  \dontrun{
  Conservation.plot <- ConservationPlot(data=thrombin10.conservedWaters,
                                        passed.waters=TRUE)
  }

}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
