% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FreeSASA.R
\name{FreeSASA.diff}
\alias{FreeSASA.diff}
\title{Atomic SASA difference of hydrated PDB via FreeSASA}
\usage{
FreeSASA.diff(atoms.oi, probeRadius = 1.4)
}
\arguments{
\item{atoms.oi}{PDB structure read into R by \code{\link[bio3d:read.pdb]{bio3d::read.pdb()}};
the \code{\link[base:data.frame]{base::data.frame()}} of \code{pdb$atom}}

\item{probeRadius}{Numerical values indicating the probe radius in Angstroms
for the \href{http://freesasa.github.io}{FreeSASA} application; default:
1.4}
}
\value{
A PDB list with \href{http://freesasa.github.io}{FreeSASA} (ProtOr)
atomic radii placed in the \emph{occupancy (o)} column and SASA values
calculated using the Lee & Richards method in the \emph{b-value (b)}
column.
}
\description{
Calculates the atomic solvent accessible surface area (SASA) of
the provided PDB (protein structure) using the FreeSASA application
(\href{http://freesasa.github.io}{website}).
}
\details{
The purpose of this function is to calculate and return the
calculated atomic SASA for the provided PDB (protein structure) and the
SASA of the protein when including the hydrating waters.

Several of the \href{http://freesasa.github.io}{FreeSASA} options are set
and \emph{\strong{NOT}} user changeable. Specifically, no log information
is returned; the \code{-L} ; the number of slices per atom is set to the
\href{http://freesasa.github.io}{FreeSASA} default of 20 (Lee & Richards
algorithm); each \href{http://freesasa.github.io}{FreeSASA} calculation
uses four (4) threads; and the ProtOr atomic radii are used.

It might be too late if you are reading this, but it is
\emph{\strong{strongly}} encouraged to run \code{\link[=FreeSASAcheck]{FreeSASAcheck()}} to
check if the \href{http://freesasa.github.io}{FreeSASA} application is
correctly installed.
}
\examples{
\dontrun{
  SASA.diff <- FreeSASA.diff(atoms.oi = thrombin.1hai$atom,
                             probeRadius = 1.4)
  head(SASA.diff)
  #   uniq.atom.ids SASA.prot SASA.hetatm SASA.lost
  # 1   THR_1_L_N_1      0.00        0.00         0
  # 2  THR_1_L_CA_2      0.00        0.00         0
  # 3   THR_1_L_C_3      0.00        0.00         0
  # 4   THR_1_L_O_4      0.00        0.00         0
  # 5  THR_1_L_CB_5      1.92        1.92         0
  # 6 THR_1_L_OG1_6     11.25       11.25         0
  #
  stem(SASA.diff$SASA.lost)
  #
  # The decimal point is at the |
  #
  #  0 | 00000000000000000000000000000000000000000000000000000000000000000000+1721
  #  2 | 00000000000001111111111122222222223333333333444444445555555555566666+88
  #  4 | 00001111111122222333333333334444444455555566677777777788899999000000+23
  #  6 | 00000111111222222222223333444455556666677778889900001112222333334455
  #  8 | 001122222333344566777888999001111222223444556667899
  # 10 | 000000001233445567888990001333344567899999
  # 12 | 00001233334446678800111233344788889
  # 14 | 00134448881223589
  # 16 | 014466389
  # 18 | 0945578888
  # 20 | 22347702
  # 22 | 246999
  # 24 | 09457
  # 26 | 44
  # 28 | 6
  # 30 |
  # 32 |
  # 34 | 9
  # 36 |
  # 38 |
  # 40 |
  # 42 |
  # 44 |
  # 46 | 9
  #
}

}
\references{
\strong{ProtOr (Protein-Organic) atomic radii:} \cr
Jerry Tsai, Robin Taylor, Cyrus Chothia, and Mark Gerstein. The packing
density in proteins: standard radii and volumes. \emph{J Mol Biol}, 1999,
\strong{290} (\emph{1}), pp 253-266.
\href{http://doi.org/10.1006/jmbi.1999.2829}{DOI: 10.1006/jmbi.1999.2829}
\href{https://www.ncbi.nlm.nih.gov/pubmed/10388571}{PMID: 10388571}

\strong{SASA calculation method:} \cr
B Lee, FM Richards. The interpretation of protein structures: estimation
of static accessibility. \emph{J Mol Biol}, 1971, \strong{55} (\emph{3}),
pp 379-400.
\href{http://doi.org/10.1016/0022-2836(71)90324-X}{DOI: 10.1016/0022-2836(71)90324-X}

\strong{FreeSASA application:} \cr
Simon Mitternacht. FreeSASA: An open source C library for solvent
accessible surface area calculations [version 1; referees: 2 approved].
\emph{F1000Research}, 2016, \strong{5}:189
\href{http://doi.org/10.12688/f1000research.7931.1}{DOI: 10.12688/f1000research.7931.1}
\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4776673/}{PMCID: PMC4776673}
\href{http://freesasa.github.io}{FreeSASA}

[version 1; referees: 2 approved]: R:version%201;%20referees:%202%20approved%5C
[DOI: 10.12688/f1000research.7931.1]: R:DOI:%2010.12688/f1000research.7931.1
[PMCID: PMC4776673]: R:PMCID:%20PMC4776673
[FreeSASA]: R:FreeSASA
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
