% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{HasXWaters}
\alias{HasXWaters}
\title{Has "X" Waters}
\usage{
HasXWaters(atoms.oi.resid, min.num.h2o = 20)
}
\arguments{
\item{atoms.oi.resid}{vector of character strings containing the standardized
three-letter amino acid residue names}

\item{min.num.h2o}{numeric value indicating the minimum number of water
molecules required to return a \code{TRUE} logical value}
}
\value{
logical indicating if the PDB structure has the minimum user defined
number of waters

numeric value indicating the number of water oxygen atoms within the
PDB structure
}
\description{
Determines if PDB structure has water molecules.
}
\details{
Determine if the PDB structure has at least the user defined number
of water oxygen atoms. The number of water oxygen atoms is returned along
with a logical value indicating if the structure satisfies the user
defined minimum.

Waters are identified using the three water three-letter residue
names: HOH, WAT, and DOD.
}
\examples{
  resids <- c("ALA", "HOH", "WAT", "ALA", "HOH", "DOD", "ALA", "HOH")
  HasXWaters(resids, min.num.h2o = 4)
  # $has.h2o.tf
  # [1] TRUE
  #
  # $num.water
  # [1] 5

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{Nearby}}, \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
