% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{Nearby}
\alias{Nearby}
\title{Nearby}
\usage{
Nearby(distances, set.idc, radius = 3.6)
}
\arguments{
\item{distances}{Vector of distance values; see above note.}

\item{set.idc}{Vector of indices (as integers) indicating the entities of
interest. This set of entities corresponds to the columns of the distance
matrix because the provided distance matrix should be square. No check is
performed on the squareness of the distance matrix because it is calculated
\emph{\strong{within}} the ConservedWaters function.}

\item{radius}{Numerical value indicating the distance to look for neighboring
entities; default: 3.6}
}
\value{
Vector of indicies.
}
\description{
Determine the entities near the entity of interest using a
distance matrix.
}
\details{
Identify the entity, or entities, near an entity or collection of
entites of interest. The previously calculated distance matrix, set of
indicies, and a user defined radius are required.

\emph{\strong{NOTE}}: This function is designed to work with
\code{\link[=BoundWaterEnvironment]{BoundWaterEnvironment()}} and the \code{\link[base:apply]{base::apply()}} function processing rows
(the \code{MARGIN = 1} option). For this reason it is \strong{NOT} a public function.
}
\examples{
  \dontrun{
  ##----- determine atom indices
  ProtHetWat.idc <- ProtHetWatIndices(thrombin.1hai$atom)
  prot.idc <- ProtHetWat.idc$prot.idc
  het.idc <- ProtHetWat.idc$het.idc
  h2o.idc <- ProtHetWat.idc$h2o.idc

  ##----- calculate the distances
  atoms.dist <- as.matrix(dist(thrombin.1hai$atom[, c("x","y","z")],
                               method = "euclidean",
                               diag = TRUE, upper = TRUE))
  diag(atoms.dist) <- NA
  atom.idc <- sort(c(prot.idc, het.idc, h2o.idc))
  atoms.dist <- atoms.dist[atom.idc, atom.idc]

  ##----- determine nearby atoms
  nearby.prot.idc <- Nearby(distances = atoms.dist[h2o.idc[1], ],
                            set.idc = prot.idc,
                            radius = 3.6)
  nearby.prot.idc
  # [1] 571
  atoms.dist[h2o.idc[1], nearby.prot]
  # [1] 3.571
  }

}
\seealso{
Other utilities: \code{\link{ConservationSet}},
  \code{\link{DetermineChainsOfInterest}},
  \code{\link{ExtractFileTimeStamp}},
  \code{\link{ExtractPDBids}}, \code{\link{FileTimeStamp}},
  \code{\link{HasXWaters}},
  \code{\link{ProtHetWatIndices}},
  \code{\link{RescaleValues}},
  \code{\link{RetainChainsOfInterest}},
  \code{\link{ReturnPDBfullPath}},
  \code{\link{StandardizeAsparticAcidNames}},
  \code{\link{StandardizeCysteineNames}},
  \code{\link{StandardizeGlutamicAcidNames}},
  \code{\link{StandardizeHistidineNames}},
  \code{\link{StandardizeLysineNames}},
  \code{\link{TimeSpan}}, \code{\link{UniqueAtomHashes}},
  \code{\link{aaStandardizeNames}},
  \code{\link{getAtomTypeCounts}},
  \code{\link{getResTypeCounts}}, \code{\link{res2xyz}},
  \code{\link{resAtomType2AtomClass}},
  \code{\link{write.basic.pdb}},
  \code{\link{write.conservedWaters.pdb}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
