% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConservedWaters.R
\name{ConservedWaters.MDS}
\alias{ConservedWaters.MDS}
\title{Conserved Molecular Dynamics Simulation Waters}
\usage{
ConservedWaters.MDS(prefix = "", cluster = 2.4, chain = "all",
  prot.h2o.dist.min = 5.1, cluster.method = "complete",
  filename = "ProteinSystem")
}
\arguments{
\item{prefix}{Directory of aligned structures; string.}

\item{cluster}{Oxygen atoms within 2.4 Angstroms or less of each other are
considered a cluster; numeric. Default value is 2.4 Angstroms.}

\item{chain}{The chain to examine. The user can define "first" and the first
chain alphabetically will be selected; this is the default. Defining "all"
will result in all chains being explored. Alternatively the user can define
individual the chains to include in the analysis; for example, \code{c("A", "B", "C")}. When defining chains, the chain designation \emph{\strong{must
be characters}}.}

\item{prot.h2o.dist.min}{The minimum distance (in Angstroms) between the
protein and waters to be considered for the conserved water clusters. Water
oxygen atoms greater than this distance are removed from the analysis.
Default value is 5.10 Angstroms.}

\item{cluster.method}{Method of clustering the waters; default is "complete".
Any other method accepted by the \code{\link[stats:hclust]{stats::hclust()}} or
\code{\link[fastcluster:hclust]{fastcluster::hclust()}} functions are appropriate. The original method used
by Sanschagrin and Kuhn is the complete linkage clustering method and is
the default. Other options include "ward.D" (equivilant to the only Ward
option in \code{R} versions 3.0.3 and earlier), "ward.D2" (implements Ward's
1963 criteria; see Murtagh and Legendre 2014), or "single" (related to the
minimal spanning tree method and adopts a "friend of friends" clustering
method). Please see \code{\link[fastcluster:hclust]{fastcluster::hclust()}} for additional and complete
information regarding clustering explanations.}

\item{filename}{The filename prefix for the returned results. Default is
"ProteinSystem"}
}
\value{
This function returns:
\itemize{
\item \strong{h2o.cluster.all}: Clusters constructed from all waters present in
the aligned PDB structures.
\item \strong{h2o.cluster.passed}: Clusters constructed from waters that passed
the \code{\link[=Mobility]{Mobility()}} and \code{\link[=NormalizedBvalue]{NormalizedBvalue()}} evaluations.
\item \strong{h2o.cluster.summary}: Summary of water clusters
\item \strong{Excel workbook}: containing the Cluster Statistics, Cluster Summaries
for \strong{all} and \strong{passed} waters, Occurrence Summaries for \strong{all} and
\strong{passed} waters, and the Initial Water Data data as individual tabs
\item \strong{call}: The user provided parameters for the function
}
}
\description{
Identifies conserved molecular dynamics simulation (MDS) waters
from a collection of PDBs.
}
\details{
Only atoms within (less than or equal to) 5.10 Angstroms of the
protein structures are included.
}
\references{
Paul C Sanschagrin and Leslie A Kuhn. Cluster analysis of
consensus water sites in thrombin and trypsin shows conservation between
serine proteases and contributions to ligand specificity. \emph{Protein
Science}, 1998, \strong{7} (\emph{10}), pp 2054-2064.
\href{http://doi.org/10.1002/pro.5560071002}{DOI: 10.1002/pro.5560071002}
\href{http://www.ncbi.nlm.nih.gov/pubmed/9792092}{PMID: 9792092}
\href{http://www.kuhnlab.bmb.msu.edu/software/watch/index.html}{WatCH webpage}

Hitesh Patel, Bjorn A. Gruning, Stefan Gunther, and Irmgard Merfort.
PyWATER: a PyMOL plug-in to find conserved water molecules in proteins by
clustering. \emph{Bioinformatics}, 2014, \strong{30} (\emph{20}), pp 2978-2980.
\href{http://doi.org/10.1093/bioinformatics/btu424}{DOI: 10.1093/bioinformatics/btu424}
\href{http://www.ncbi.nlm.nih.gov/pubmed/24990608}{PMID: 24990608}
\href{https://github.com/hiteshpatel379/PyWATER/blob/master/README.rst}{PyWATER on GitHub}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
