% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.post.processing.R
\name{run.post.processing}
\alias{run.post.processing}
\title{run.post.processing}
\usage{
run.post.processing(variant.specification, output.directory,
  code.directory = NULL, log.directory = NULL, config.file = NULL,
  job.name.prefix = NULL, quiet = FALSE, email = NULL,
  verify.options = !quiet)
}
\arguments{
\item{variant.specification}{Data frame specifying files to be processed}

\item{output.directory}{Path to directory where output should be saved}

\item{code.directory}{Directory where code should be saved}

\item{log.directory}{Directory where log files should be saved}

\item{config.file}{Path to config file}

\item{job.name.prefix}{Prefix for job names on the cluster}

\item{quiet}{Logical indicating whether to print commands to screen rather than submit the job}

\item{email}{Email address that should be notified when job finishes. If NULL or FALSE, no email is sent}

\item{verify.options}{Logical indicating whether \code{verify.varitas.options()} should be run.}
}
\value{
None
}
\description{
Submit post-processing job to the cluster with appropriate job dependencies
}
\examples{
run.post.processing(
  variant.specification = data.frame(
    sample.id = c('a', 'b'),
    vcf = c('a.vcf', 'b.vcf'),
    caller = c('mutect', 'mutect'),
    job.dependency = c('example1', 'example2')
  ),
  output.directory = '.',
  quiet = TRUE
)

}
