% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_misc.R
\name{stdmean2.from.t}
\alias{stdmean2.from.t}
\title{Computes Cohen's d from pooled-variance t statistic}
\usage{
stdmean2.from.t(t, n1, n2)
}
\arguments{
\item{t}{pooled-variance t statistic}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns Cohen's d and its equal-variance standard error
}
\description{
This function computes Cohen's d for a 2-group design (which is a
standardized mean difference with a weighted variance standardizer) using
a pooled-variance independent-samples t statistic and the two sample sizes.
This function also computes the standard error for Cohen's d. The Cohen's d
estimate and standard error assume equality of population variances.
}
\examples{
stdmean2.from.t(3.27, 25, 25)

# Should return:
#             Estimate       SE
# Cohen's d  0.9439677 0.298801

}
