% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.W.R
\name{cov.W}
\alias{cov.W}
\title{Within-group covariance matrix}
\usage{
cov.W(X, groups, sex = NULL)
}
\arguments{
\item{X}{a data matrix with variables in columns and group names as row names}

\item{groups}{a character / factor vector containing grouping variable}

\item{sex}{NULL (default). A character / factor vector containing sex variable,
to remove sexual dimorphism by averaging males and females in each group}
}
\value{
The pooled within-group covariance matrix
}
\description{
Computes the pooled within-group covariance matrix.
The effect of sexual dimorphism can be removed by using, for each group,
the average of the covariance matrix of males and the covariance matrix of females.
}
\examples{

# Data matrix of 2D landmark coordinates
data("Tropheus")
PHEN <- as.matrix(Tropheus[which(names(Tropheus) == "X1"):which(names(Tropheus) == "Y19")])

# Procrustes superimposition
library("geomorph")
PHEN_array <- arrayspecs(PHEN, p = 19, k = 2)
phen.gpa <- gpagen(PHEN_array, print.progress = FALSE)
proc.coord <- two.d.array(phen.gpa$coords)

# Within-group covariance matrix for all populations
W <- cov.W(proc.coord, groups = Tropheus$POP.ID)

# Within-group covariance matrix for all populations, pooled by sex
W.mf <- cov.W(proc.coord, groups = Tropheus$POP.ID, sex = Tropheus$Sex)

}
\seealso{
\code{\link[stats]{cov}}
}
