% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_scale.R
\name{addscale}
\alias{addscale}
\title{function to add a scale to a image plot}
\usage{
addscale(
  z,
  zlim = range(z, na.rm = TRUE),
  col = grDevices::heat.colors(12),
  breaks = pretty(zlim),
  horiz = TRUE,
  ylim = NULL,
  xlim = NULL,
  ...
)
}
\arguments{
\item{z}{matrix or vector}

\item{zlim}{z limit}

\item{col}{color}

\item{breaks}{interval for the tickmarks}

\item{horiz}{TRUE (default) to a horizontal scale}

\item{ylim}{y limitS}

\item{xlim}{x limit}

\item{...}{other arguments to plot}
}
\description{
method to plot a scale in image plot.
}
\examples{
\dontrun{
mat <- matrix(100:1,ncol = 10, byrow = F)
cor <- grDevices::heat.colors(100)
image(mat,axe = FALSE, main = "numbers from 1 to 100", col = cor)
axis(2)
addscale(mat, col = cor)
}
}
