% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R
\name{embed}
\alias{embed}
\alias{embed_vimeo}
\alias{embed_youtube}
\title{Creates an iframe for video-embedding}
\usage{
embed_vimeo(id, width = 500, height = 281, frameborder = 0,
  allow_full_screen = TRUE, query = NULL)

embed_youtube(id, width = 420, height = 315, frameborder = 0,
  allow_full_screen = TRUE, query = NULL)
}
\arguments{
\item{id}{character, identifier provided by the service}

\item{width}{numeric, width of iframe (px)}

\item{height}{numeric, height of iframe (px)}

\item{frameborder}{numeric, size of frame border (px)}

\item{allow_full_screen}{logical, indicates if to allow fullscreen}

\item{query}{list of items to include in query string}
}
\value{
html \code{<iframe>} element
}
\description{
These functions are used to embed video into your RMarkdown html documents,
or into your Shiny apps. There are currently functions for you to embed from
either YouTube or Vimeo.
}
\details{
Both of these services allow you to customize a lot of things by specifying
an optional query string. The specification for the query string will differ
according to the service being used:

\describe{
  \item{YouTube}{\url{https://developers.google.com/youtube/player_parameters}}
  \item{Vimeo}{\url{https://developer.vimeo.com/player/embedding}}
}
}
\examples{
embed_vimeo("45196609")
embed_youtube("dQw4w9WgXcQ")
embed_youtube("8SGif63VW6E", query = list(start = secs("4m12s")))

}

