% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Config.R
\name{Config}
\alias{Config}
\title{R6 Class representing a configuration object}
\description{
R6 Class representing a configuration object

R6 Class representing a configuration object
}
\details{
The special sublist \code{directories} is structured to contain three items for each
directory name:
\itemize{
\item \code{versioned}: a T/F value specifying whether the directory is versioned
\item \code{path}: the full path to the top level of that directory.
\item \code{files}: A named list referencing file paths within that directory.
}

If the directory is versioned, a version must be set in the \code{versions} sublist of the
config list. \code{versions} is itself a named list where each key corresponds to a
versioned folder in \code{directories} and the value gives the particular folder version
(for example, a timestamp) that corresponds to the particular run.
}
\seealso{
\code{\link[=pull_from_list]{pull_from_list()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{config_list}}{The list representation of the Config object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Config-new}{\code{Config$new()}}
\item \href{#method-Config-print}{\code{Config$print()}}
\item \href{#method-Config-get}{\code{Config$get()}}
\item \href{#method-Config-get_dir_path}{\code{Config$get_dir_path()}}
\item \href{#method-Config-get_file_path}{\code{Config$get_file_path()}}
\item \href{#method-Config-read}{\code{Config$read()}}
\item \href{#method-Config-write}{\code{Config$write()}}
\item \href{#method-Config-write_self}{\code{Config$write_self()}}
\item \href{#method-Config-clone}{\code{Config$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-new"></a>}}
\if{latex}{\out{\hypertarget{method-Config-new}{}}}
\subsection{Method \code{new()}}{
Create a new Config object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$new(config_list, versions = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config_list}}{either a list or a filepath to a YAML file containing that list}

\item{\code{versions}}{(default NULL) A named list containing versions for versioned
directories. If passed, used to define or update items in \code{config_list$versions}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-print"></a>}}
\if{latex}{\out{\hypertarget{method-Config-print}{}}}
\subsection{Method \code{print()}}{
Print the list representation of the Config object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-get"></a>}}
\if{latex}{\out{\hypertarget{method-Config-get}{}}}
\subsection{Method \code{get()}}{
Get a subset of the \code{config_list}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$get(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Nested indices (character or numeric) down the config list}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If no parameters are passed, returns the entire config_list
}

\subsection{Returns}{
A subset of the list. If the item is NULL or missing, returns an error
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-get_dir_path"></a>}}
\if{latex}{\out{\hypertarget{method-Config-get_dir_path}{}}}
\subsection{Method \code{get_dir_path()}}{
Construct a directory path from the config object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$get_dir_path(
  dir_name,
  custom_version = NULL,
  fail_if_does_not_exist = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir_name}}{Directory name}

\item{\code{custom_version}}{(character, default NULL) A custom version that will be
applied to this folder, rather than pulling from \code{config_list$versions[[dir]]}.
Only applies to versioned folders.}

\item{\code{fail_if_does_not_exist}}{(logical, default FALSE) should this method return an
error if the directory in question does not already exist?}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Works differently for versioned and non-versioned directories. See the class
description for more information.
}

\subsection{Returns}{
The full path to the directory
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-get_file_path"></a>}}
\if{latex}{\out{\hypertarget{method-Config-get_file_path}{}}}
\subsection{Method \code{get_file_path()}}{
Construct a file path from the config object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$get_file_path(
  dir_name,
  file_name,
  custom_version = NULL,
  fail_if_does_not_exist = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir_name}}{Directory name}

\item{\code{file_name}}{File name within that directory}

\item{\code{custom_version}}{(character, default NULL) A custom version that will be
applied to this folder, rather than pulling from \code{config_list$versions[[dir]]}.
Only applies to versioned folders.}

\item{\code{fail_if_does_not_exist}}{(logical, default FALSE) should this method return an
error if the directory in question does not already exist?}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Looks for the file path under:
\code{config_list$directories[[dir_name]]$files[[file_name]]}
}

\subsection{Returns}{
The full path to the file
Read a file based on the config
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-read"></a>}}
\if{latex}{\out{\hypertarget{method-Config-read}{}}}
\subsection{Method \code{read()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$read(dir_name, file_name, ..., custom_version = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir_name}}{Directory name}

\item{\code{file_name}}{File name within that directory}

\item{\code{...}}{Optional file reading arguments to pass to \code{\link[=autoread]{autoread()}}}

\item{\code{custom_version}}{(character, default NULL) A custom version that will be
applied to this folder, rather than pulling from \code{config_list$versions[[dir]]}.
Only applies to versioned folders. If passed, this argument must always be
explicitly named.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object loaded by \code{\link[=autoread]{autoread()}}
Write an object to file based on the config
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-write"></a>}}
\if{latex}{\out{\hypertarget{method-Config-write}{}}}
\subsection{Method \code{write()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$write(x, dir_name, file_name, ..., custom_version = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Object to write}

\item{\code{dir_name}}{Directory name}

\item{\code{file_name}}{File name within that directory}

\item{\code{...}}{Optional file writing arguments to pass to \code{\link[=autowrite]{autowrite()}}}

\item{\code{custom_version}}{(character, default NULL) A custom version that will be
applied to this folder, rather than pulling from \code{config_list$versions[[dir]]}.
Only applies to versioned folders. If passed, this argument must always be
explicitly named.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly passes TRUE if successful
Convenience function: write the config list to a folder as 'config.yaml'
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-write_self"></a>}}
\if{latex}{\out{\hypertarget{method-Config-write_self}{}}}
\subsection{Method \code{write_self()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$write_self(dir_name, ..., custom_version = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir_name}}{Directory name}

\item{\code{...}}{Optional file writing arguments to pass to \code{\link[=autowrite]{autowrite()}}}

\item{\code{custom_version}}{(character, default NULL) A custom version that will be
applied to this folder, rather than pulling from \code{config_list$versions[[dir]]}.
Only applies to versioned folders. If passed, this argument must always be
explicitly named.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly passes TRUE if successful
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Config-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Config-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Config$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
