% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\docType{class}
\name{simulation}
\alias{simulation}
\title{simulation}
\description{
Advances one or more villages through time
}
\section{Methods}{

\describe{
\item{\code{run_model()}}{Runs the simulation}
}
Creates a new Simulation instance
}

\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{length}}{The total number of time steps that the simulation runs for}

\item{\code{villages}}{A list of villages that the simulator will run}

\item{\code{writer}}{An instance of a data_writer class for writing village data to disk}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{simulation$new()}}
\item \href{#method-run_model}{\code{simulation$run_model()}}
\item \href{#method-clone}{\code{simulation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new simulation object to control the experiment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simulation$new(length, villages, writer = villager::data_writer$new())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{length}}{The number of steps the simulation takes}

\item{\code{villages}}{A list of villages that will be simulated}

\item{\code{writer}}{The data writer to be used with the villages
Runs the simulation}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_model"></a>}}
\if{latex}{\out{\hypertarget{method-run_model}{}}}
\subsection{Method \code{run_model()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simulation$run_model()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{simulation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
