% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictiveness_point_est.R
\name{predictiveness_point_est}
\alias{predictiveness_point_est}
\title{Estimate a nonparametric predictiveness functional}
\usage{
predictiveness_point_est(
  fitted_values,
  y,
  weights = rep(1, length(y)),
  type = "r_squared",
  na.rm = FALSE
)
}
\arguments{
\item{fitted_values}{fitted values from a regression function.}

\item{y}{the outcome.}

\item{weights}{weights for the computed influence curve (e.g., inverse probability weights for coarsened-at-random settings)}

\item{type}{which parameter are you estimating (defaults to \code{anova}, for ANOVA-based variable importance)?}

\item{na.rm}{logical; should NA's be removed in computation? (defaults to \code{FALSE})}
}
\value{
The estimated measure of predictiveness.
}
\description{
Compute nonparametric estimates of the chosen measure of predictiveness.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
