% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mideal.R
\name{mideal}
\alias{mideal}
\alias{dmideal}
\alias{pmideal}
\alias{qmideal}
\alias{rmideal}
\title{Ideal Distribution of Meteor Magnitudes}
\usage{
dmideal(m, psi = 0, log = FALSE)

pmideal(m, psi = 0, lower.tail = TRUE, log = FALSE)

qmideal(p, psi = 0, lower.tail = TRUE)

rmideal(n, psi = 0)
}
\arguments{
\item{m}{numeric; meteor magnitude.}

\item{psi}{numeric; the location parameter of a probability distribution.
It is the only parameter of the distribution.}

\item{log}{logical; if \code{TRUE}, probabilities p are given as \code{log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default) probabilities are
\eqn{P[M \le m]}, otherwise, \eqn{P[M > m]}.}

\item{p}{numeric; probability.}

\item{n}{numeric; count of meteor magnitudes.}
}
\value{
\code{dmideal} gives the density, \code{pmideal} gives the distribution function,
\code{qmideal} gives the quantile function and \code{rmideal} generates random deviates.

The length of the result is determined by \code{n} for \code{rmideal}, and is the maximum
of the lengths of the numerical vector arguments for the other functions.

\code{qmideal} can return \code{NaN} value with a warning.
}
\description{
Density, distribution function, quantile function and random generation
for the ideal distribution of meteor magnitudes.
}
\details{
The density of the ideal distribution of meteor magnitudes is
\deqn{
    {\displaystyle \frac{\mathrm{d}p}{\mathrm{d}m} = \frac{3}{2} \, \log(r) \sqrt{\frac{r^{3 \, \psi + 2 \, m}}{(r^\psi + r^m)^5}}}
}
where \eqn{m} is the meteor magnitude, \eqn{r = 10^{0.4} \approx 2.51189 \dots} is a constant and
\eqn{\psi} is the only parameter of this magnitude distribution.
}
\examples{
old_par <- par(mfrow = c(2,2))
psi <- 5.0
plot(
    function(m) dmideal(m, psi, log = FALSE),
    -5, 10,
    main = paste0('Density of the Ideal Meteor Magnitude\nDistribution (psi = ', psi, ')'),
    col = "blue",
    xlab = 'm',
    ylab = 'dp/dm'
)
abline(v=psi, col="red")

plot(
    function(m) dmideal(m, psi, log = TRUE),
    -5, 10,
    main = paste0('Density of the Ideal Meteor Magnitude\nDistribution (psi = ', psi, ')'),
    col = "blue",
    xlab = 'm',
    ylab = 'log( dp/dm )'
)
abline(v=psi, col="red")

plot(
    function(m) pmideal(m, psi),
    -5, 10,
    main = paste0('Probability of the Ideal Meteor Magnitude\nDistribution (psi = ', psi, ')'),
    col = "blue",
    xlab = 'm',
    ylab = 'p'
)
abline(v=psi, col="red")

plot(
    function(p) qmideal(p, psi),
    0.01, 0.99,
    main = paste('Quantile of the Ideal Meteor Magnitude\nDistribution (psi = ', psi, ')'),
    col = "blue",
    xlab = 'p',
    ylab = 'm'
)
abline(h=psi, col="red")

# generate random meteor magnitudes
m <- rmideal(1000, psi)

# log likelihood function
llr <- function(psi) {
    -sum(dmideal(m, psi, log=TRUE))
}

# maximum likelihood estimation (MLE) of psi
est <- optim(2, llr, method='Brent', lower=0, upper=8, hessian=TRUE)

# estimations
est$par # mean of psi
sqrt(1/est$hessian[1][1]) # standard deviation of psi

par(old_par)
}
\references{
Richter, J. (2018) \emph{About the mass and magnitude distributions of meteor showers}.
WGN, Journal of the International Meteor Organization, vol. 46, no. 1, p. 34-38
}
