% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_hour.R
\name{cut_hour}
\alias{cut_hour}
\title{Convert a numeric variable for hours into categorical}
\usage{
cut_hour(metric, cuts, unit = "hours", lbound = 0, ubound = 100)
}
\arguments{
\item{metric}{A numeric variable representing hours.}

\item{cuts}{A numeric vector of minimum length 3 to represent the
cut points required. The minimum and maximum values provided in the vector
are inclusive.}

\item{unit}{String to specify the unit of the labels. Defaults to "hours".}

\item{lbound}{Numeric. Specifies the lower bound (inclusive) value for the
minimum label. Defaults to 0.}

\item{ubound}{Numeric. Specifies the upper bound (inclusive) value for the
maximum label. Defaults to 100.}
}
\value{
Character vector representing a converted categorical variable, appended
with the label of the unit. See \code{examples} for more information.
}
\description{
Supply a numeric variable, e.g. \code{Collaboration_hours}, and return a character
vector.
}
\details{
This is used within \code{create_dist()} for numeric to categorical conversion.
}
\examples{
# Direct use
cut_hour(1:30, cuts = c(15, 20, 25))

# Use on a query
cut_hour(pq_data$Collaboration_hours, cuts = c(10, 15, 20))

}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{extract_date_range}()},
\code{\link{extract_hr}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{maxmin}()},
\code{\link{read_preamble}()},
\code{\link{rgb2hex}()},
\code{\link{totals_bind}()},
\code{\link{totals_col}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}
}
\concept{Support}
