% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_metrics_one_grouped}
\alias{plot_metrics_one_grouped}
\title{Output averages for multiple variables}
\usage{
plot_metrics_one_grouped(
  data,
  col,
  col_group,
  limits = NULL,
  negative = FALSE,
  title = TRUE,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble containing item measures}

\item{col}{The column holding metric values}

\item{col_group}{The column holding groups to compare}

\item{limits}{The scale limits. Set NULL to extract limits from the labels. NOT IMPLEMENTED YET.}

\item{negative}{If FALSE (default), negative values are recoded as missing values.}

\item{title}{If TRUE (default) shows a plot title derived from the column labels.
Disable the title with FALSE or provide a custom title as character value.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_metrics}.}
}
\value{
A ggplot object
}
\description{
Output averages for multiple variables
}
\examples{
library(volker)
data <- volker::chatgpt

plot_metrics_one_grouped(data, sd_age, sd_gender)

}
\keyword{internal}
