% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_metrics}
\alias{tab_metrics}
\title{Output a table with distribution parameters}
\usage{
tab_metrics(data, cols, col_group = NULL, clean = TRUE, ...)
}
\arguments{
\item{data}{A data frame}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{col_group}{Optional, a grouping column (without quotes).}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Other parameters passed to the appropriate table function}
}
\value{
A volker tibble
}
\description{
The table type depends on the number of selected columns:
\itemize{
\item One column: see \link{tab_metrics_one}
\item Multiple columns: see \link{tab_metrics_items}
\item One column and one grouping column: see \link{tab_metrics_one_grouped}
\item Multiple columns and one grouping column: see \link{tab_metrics_items_grouped}
}
}
\examples{
library(volker)
data <- volker::chatgpt

tab_metrics(data, sd_age)

}
