% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddText.R
\name{AddText.activity.reddit}
\alias{AddText.activity.reddit}
\title{Add columns containing text data to reddit activity network dataframes}
\usage{
\method{AddText}{activity.reddit}(net, data, cleanText = FALSE, ...)
}
\arguments{
\item{net}{A named list of dataframes \code{nodes} and \code{edges} generated by \code{Create}.}

\item{data}{A dataframe generated by \code{Collect}.}

\item{cleanText}{Logical. Simple removal of problematic characters for XML 1.0 standard. Implemented to prevent
reddit specific XML control character errors when generating graphml files. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges} including columns
containing text data.
}
\description{
Add columns containing text data to reddit activity network dataframes
}
\examples{
\dontrun{
# add text to an activity network
net_activity <- collect_rd |>
  Create("activity") |>
  AddText(collect_rd)

# network
net_activity$nodes
net_activity$edges
}

}
