% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubtrans_ch_nearby.R
\name{pubtrans_ch_nearby}
\alias{pubtrans_ch_nearby}
\title{Issue a walkalytics pubtrans query}
\usage{
pubtrans_ch_nearby(x, y, max_walktime = 10, key = "my_walkalytics_key")
}
\arguments{
\item{x}{latitude of starting point.}

\item{y}{longitude of starting point.}

\item{max_walktime}{output filter for maximum walking time in minutes.}

\item{key}{your \code{walkalytics} subscription key which provides access to the API.}
}
\value{
The \link[httr]{response} object from the request. Use \link[walkalytics]{get_stops} to directly extract nearby
    public transportation stops and estimated walking times from the starting point to the stations.
}
\description{
\code{pubtrans_ch_nearby} calls the \code{walkalytics} pubtrans API which returns nearby public tansportation stops for Switzerland.
}
\details{
To get an API key, you need to register at \url{https://dev.walkalytics.com/signin}.
    With the free starter account, you can make up to 100 calls a week to the API.
}
\examples{
\donttest{
pubtrans_ch_nearby(x = 8.0526331, y = 47.3933375, max_walktime = 10, key = "abcd1234")
}
}
\references{
\href{https://dev.walkalytics.com/docs/services/}{Walkalytics API documentations}
}
