% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frange.detec.R
\name{frange.detec}
\alias{frange.detec}
\title{Detect frequency range on wave objects}
\usage{
frange.detec(wave, wl = 512, fsmooth = 0.1, threshold = 10, 
dB.threshold = NULL, wn = "hanning", flim = c(0, 22), bp = NULL, 
fast.spec = FALSE, ovlp = 50, pal = reverse.gray.colors.2, 
 widths = c(2, 1), main = NULL, plot = TRUE, all.detec = FALSE)
}
\arguments{
\item{wave}{A 'wave' object produced by  \code{\link[tuneR]{readWave}} or similar functions.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512. This is used for calculating the frequency spectrum (using \code{\link[seewave]{meanspec}}) 
and producing the spectrogram (using \code{\link[seewave]{spectro}}, if \code{plot = TRUE}).}

\item{fsmooth}{A numeric vector of length 1 to smooth the frequency spectrum with a mean
sliding window in kHz. This help to average amplitude "hills" to minimize the effect of
amplitude modulation. Default is 0.1.}

\item{threshold}{Amplitude threshold (\%) for frequency range detection. The frequency range (not the cumulative amplitude) is represented as percentage (100\% = highest amplitude). Default is 10. Ignored if 'dB.threshold' is supplied.}

\item{dB.threshold}{Amplitude threshold for frequency range detection (in dB). The
value indicates the decrease in dB in relation to the highest amplitude (e.g. 
the peak frequency) in which range will be detected. For instance a 
\code{dB.threshold = 20} means that the amplitude threshold would be 20 dB below
the highest amplitude. If provided 'threshold' is ignored. Default is \code{NULL}. 
Note that the power spectrum is normalized when using a dB scale, so it looks different than the one produced when no dB scale is used (e.g. when using 'threshold' argument).}

\item{wn}{Character vector of length 1 specifying window name. Default is 
"hanning". See function \code{\link[seewave]{ftwindow}} for more options. This is used for calculating the frequency spectrum (using \code{\link[seewave]{meanspec}}) and producing the spectrogram (using \code{\link[seewave]{spectro}}, if \code{plot = TRUE}).}

\item{flim}{A numeric vector of length 2 for the frequency limit of 
the spectrogram (in kHz), as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz) or "frange" to indicate that values in 'bottom.freq' 
and 'top.freq' columns will be used as bandpass limits. Default is c(0, 22).}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms, which substantially 
increases performance (much faster), although some options become unavailable, as collevels, and sc (amplitude scale).
This option is indicated for signals with high background noise levels. Palette colors \code{\link[monitoR]{gray.1}}, \code{\link[monitoR]{gray.2}}, 
\code{\link[monitoR]{gray.3}}, \code{\link[monitoR]{topo.1}} and \code{\link[monitoR]{rainbow.1}} (which should be imported from the package monitoR) seem
to work better with 'fast.spec' spectrograms. Palette colors \code{\link[monitoR]{gray.1}}, \code{\link[monitoR]{gray.2}}, 
\code{\link[monitoR]{gray.3}} offer 
decreasing darkness levels.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 50. This is used for calculating the frequency spectrum (using \code{\link[seewave]{meanspec}}) and producing the spectrogram (using \code{\link[seewave]{spectro}}, if \code{plot = TRUE}).}

\item{pal}{Color palette function for spectrogram. Default is reverse.gray.colors.2. See 
\code{\link[seewave]{spectro}} for more palettes. Palettes as \code{\link[monitoR]{gray.2}} may work better when \code{fast.spec = TRUE}.}

\item{widths}{Numeric vector of length 2 to control the relative widths of the spectro (first element) and spectrum (second element).}

\item{main}{Character vector of length 1 specifying the plot title. Default is \code{NULL}.}

\item{plot}{Logical. Controls whether an image file is produced for each selection (in the 
working directory). Default is \code{TRUE}.}

\item{all.detec}{Logical. If \code{TRUE} returns the start and end of all detected amplitude
"hills". Otherwise only the range is returned. Default is \code{FALSE}.}
}
\value{
A data frame with 2 columns for low and high frequency values. A plot is produced (in the graphic device) if \code{plot = TRUE} (see details).
}
\description{
\code{frange.detec} detects the frequency range of acoustic signals on wave objects.
}
\details{
This functions aims to automatize the detection of frequency ranges. The frequency range is calculated as follows:
\itemize{  
 \item bottom.freq = the start frequency of the amplitude 'hill' containing the highest amplitude at the given threshold.  
 \item top.freq = the end frequency of the amplitude 'hill' containing the highest amplitude at the given threshold.
  }
  If \code{plot = TRUE} a graph including a spectrogram and a frequency spectrum is 
  produced in the graphic device. The graph would include gray areas in the frequency ranges excluded by the bandpass ('bp' argument), dotted lines highlighting the detected range.
}
\examples{
{
data(tico)
frange.detec(wave = tico, wl = 512, fsmooth = 0.01, threshold = 1, bp = c(2, 8),
 widths = c(4, 2))

data(sheep)
frange.detec(wave = sheep, wl = 512, fsmooth = 0.2, threshold = 50, bp = c(0.3, 1), 
flim = c(0, 1.5), pal = reverse.heat.colors, main = "sheep")
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{frange}}, \code{\link{autodetec}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
