% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtersels.R
\name{filtersels}
\alias{filtersels}
\title{Subset selection data frames based on manually filtered image files}
\usage{
filtersels(X, path = NULL, lspec = FALSE, pdf = FALSE)
}
\arguments{
\item{X}{data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "sel": number of the selections. The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can 
be used as the input data frame.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{lspec}{A logical argument indicating if the image files to be use for filtering were produced by the function \code{\link{lspec}}. 
All the image files that correspond to a sound file must be deleted in order to be filtered out.}

\item{pdf}{A logical argument indicating if the image files are in .pdf format. Default is \code{FALSE}. Note that
pdf files can only be generated using \code{\link{lspec2pdf}} (so they are long spectrograms). 
Then, if \code{TRUE}, \code{lspec} argument is ignored.}
}
\value{
If all .wav files are ok, returns message "All files are ok!".
  Otherwise returns "These file(s) cannot be read" message with names of the
  corrupted .wav files.
}
\description{
\code{filtersels} subsets selection data frames based on image files that have been manually filtered.
}
\details{
This function subsets selections (or sound files if \code{lspec} is \code{TRUE}) listed in a data frame
 based on the image files from spectrogram-creating functions (e.g. \code{\link{specreator}}) in the 
 working directory. Only the selections/sound files with and image in the working directory will remain. 
 This is useful for excluding selections from undesired signals. Note that the
 image files should be in the working directory (or the directory provided in 'path').
}
\examples{
\dontrun{ 
# First set temporary folder
setwd(tempdir())

# save wav file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "manualoc.df"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")

specreator(manualoc.df, flim = c(0, 11), inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1), 
picsize = 2, res = 300, cexlab = 2, mar = 0.05, wl = 300)

#go to the working directory and delete some images

#filter selection data frame

#this data frame does not have the selections corresponding to the images that were deleted
fmloc

#now using lspec images
lspec(sxrow = 2, rows = 8, pal = reverse.heat.colors, wl = 300, ovlp = 10)

#go to the working directory and delete lspec images (the ones with several rows of spectrograms)

#filter selection data frame

}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}

