% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imp.raven.R
\name{imp.raven}
\alias{imp.raven}
\title{Import Raven selections}
\usage{
imp.raven(path = NULL, sound.file.col = NULL, all.data = FALSE, recursive = FALSE,
 name.from.file = FALSE, ext.case = NULL, freq.cols = TRUE)
}
\arguments{
\item{path}{A character string indicating the path of the directory in which to look for the text files. 
If not provided (default) the function searches into the current working directory. Default is \code{NULL}).}

\item{sound.file.col}{A character string with the name of the column listing the sound files in 
the selection text files. Default is \code{NULL}). If provided, the output data
frame will contained all columns needed for subsequent analysis in \code{\link{warbleR}}. 
Duplicated rows, as when "waveform" and "spectrogram" information are included for the same selection, will be removed.
All selection files must contain "Selection", "Begin.Time" and "End.Time" columns.}

\item{all.data}{Logical. If \code{TRUE}) all columns in text files are returned, 
keeping the name columns as in the raven files (not in "warbleR" format). Default is \code{FALSE}). Columns absent in some selection files will be filled with NA's.}

\item{recursive}{Logical. If \code{TRUE}) the listing recurse into sub-directories.}

\item{name.from.file}{Logical. If \code{TRUE}) the sound file names are extracted from the selection text file name. 
It asssumes that selections files contained the suffix "Table.1.selections.txt" or "selections.txt". 
Note that by default it will assume that the extension file name is ".wav". This can be control using the
argumet 'ext.wav'. Default is \code{FALSE}). Ignored if sound.file.col' is provided and/or all.data is \code{TRUE}).}

\item{ext.case}{Character string of length 1 to specify whether sound file extensions are in upper or lower case. This should match the extension of the
of the .wav files from which the selection were made. It must be either 'upper' or 'lower'. Only needed when 'name.from.file' is \code{TRUE}). 
Ignored if 'sound.file.col' is provided and/or all.data is \code{TRUE}).}

\item{freq.cols}{Logical. If \code{TRUE}) 'Low Freq' and 'High Freq' columns are also imported. Ignored if all.data is \code{TRUE}.}
}
\value{
A single data frame with information of the selection files. If all.data argument is set to \code{FALSE}) the data 
frame contains the following columns: selec, start, end, and selec.file. If sound.file.col is provided the data frame
will also contain a 'sound.files' column. In addition, all rows with duplicated data are removed. This is useful when 
both spectrogram and waveform views are included in the Raven selection files. If all.data is set to \code{TRUE} then all 
columns in selection files are returned.
}
\description{
\code{imp.raven} imports Raven selection data from many files simultaneously. Files must be in .txt format.
}
\details{
The function import raven selection data from many files simultaneously. Files must be in .txt format. Note that selection 
files including data from mulitple recordings cannot be imported. Make sure that NO OTHER TEXT FILES are found
in the working directory, only raven generated selections files.
}
\examples{
\dontrun{
# First set temporary folder
setwd(tempdir())

data(selection.files)

write.table(selection.files[[1]],file = "100889-Garrulax monileger.selections.txt",
row.names = FALSE, sep= '\\t')

write.table(selection.files[[2]],file = "1023-Arremonops rufivirgatus.selections.txt",
row.names = FALSE, sep= '\\t')

## MAKE SURE THERE ARE NO OTHER .txt FILES IN THE WORKING DIRECTORY
 #providing the name of the column with the sound file names
rav.dat<-imp.raven(sound.file.col = "End.File", all.data = FALSE)

View(rav.dat)

#getting all the data
rav.dat<-imp.raven(all.data = TRUE)
View(rav.dat)
}

}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
\seealso{
\code{\link{imp.syrinx}}
}

