% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_getis.R
\name{ww_local_getis_ord_g}
\alias{ww_local_getis_ord_g}
\alias{ww_local_getis_ord_g_vec}
\alias{ww_local_getis_ord_pvalue}
\alias{ww_local_getis_ord_pvalue_vec}
\alias{ww_local_getis_ord}
\title{Local Getis-Ord G and G* statistic}
\usage{
ww_local_getis_ord_g(data, ...)

ww_local_getis_ord_g_vec(
  truth,
  estimate,
  wt = NULL,
  alternative = "two.sided",
  nsim = 499,
  na_rm = TRUE,
  ...,
  include_self = FALSE
)

ww_local_getis_ord_pvalue(data, ...)

ww_local_getis_ord_pvalue_vec(
  truth,
  estimate,
  wt = NULL,
  alternative = "two.sided",
  nsim = 499,
  na_rm = TRUE,
  ...,
  include_self = FALSE
)

ww_local_getis_ord(
  data,
  truth,
  estimate,
  wt = NULL,
  alternative = "two.sided",
  nsim = 499,
  na_rm = TRUE,
  ...,
  include_self = FALSE
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by the \code{truth}
and \code{estimate} arguments.}

\item{...}{Arguments passed to \code{\link[spdep:localG]{spdep::localG_perm()}}}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{wt}{A "listw" object, for instance as created with \code{\link[=ww_build_weights]{ww_build_weights()}}.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{nsim}{default 499, number of conditonal permutation simulations}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{include_self}{Include each region itself in its own list of neighbors?
Only used when \code{wt} is \code{NULL}, and if \code{TRUE} means this function calculates
G* instead of G.}
}
\value{
A tibble with columns .metric, .estimator, and .estimate and \code{nrow(data)} rows of values.
For grouped data frames, the number of rows returned will be the same as the number of groups.
For \verb{_vec()} functions, a numeric vector of \code{length(truth)} (or NA).
}
\description{
Calculate the local Getis-Ord G and G* statistic for model residuals.
\code{ww_local_getis_ord_g()} returns the statistic itself, while
\code{ww_local_getis_ord_pvalue()} returns the associated p value.
\code{ww_local_getis_ord()} returns both.
}
\examples{
\dontshow{if (rlang::is_installed("sfdep")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(guerry, package = "sfdep")

guerry_modeled <- guerry
guerry_lm <- lm(crime_pers ~ literacy, guerry_modeled)
guerry_modeled$predictions <- predict(guerry_lm, guerry_modeled)

ww_local_getis_ord_g(guerry_modeled, crime_pers, predictions)
ww_local_getis_ord(guerry_modeled, crime_pers, predictions)
ww_local_getis_ord(guerry_modeled, crime_pers, predictions, include_self = TRUE)
\dontshow{\}) # examplesIf}
}
