% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_geary.R
\name{ww_global_geary_c}
\alias{ww_global_geary_c}
\alias{ww_global_geary_c_vec}
\alias{ww_global_geary_pvalue}
\alias{ww_global_geary_pvalue_vec}
\title{Global Geary's C statistic}
\usage{
ww_global_geary_c(data, ...)

ww_global_geary_c_vec(truth, estimate, wt, na_rm = FALSE, ...)

ww_global_geary_pvalue(data, ...)

ww_global_geary_pvalue_vec(truth, estimate, wt = NULL, na_rm = FALSE, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by the \code{truth}
and \code{estimate} arguments.}

\item{...}{Additional arguments passed to \code{\link[spdep:geary]{spdep::geary()}} (for
\code{ww_global_geary_c()}) or \code{\link[spdep:geary.test]{spdep::geary.test()}} (for
\code{ww_global_geary_pvalue()}).}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{wt}{A \code{listw} object, for instance as created with \code{\link[=ww_build_weights]{ww_build_weights()}}.
For data.frame input, may also be a function that takes \code{data} and returns a
\code{listw} object.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A tibble with columns .metric, .estimator, and .estimate and 1 row of values.
For grouped data frames, the number of rows returned will be the same as the
number of groups.
For \verb{_vec()} functions, a single value (or NA).
}
\description{
Calculate the global Geary's C statistic for model residuals.
\code{ww_global_geary_c()} returns the statistic itself, while
\code{ww_global_geary_pvalue()} returns the associated p value.
These functions are meant to help assess model predictions, for instance by
identifying if there are clusters of higher residuals than expected. For
statistical testing and inference applications, use
\code{\link[spdep:geary.test]{spdep::geary.test()}} instead.
}
\details{
These functions can be used for geographic or projected coordinate reference
systems and expect 2D data.
}
\examples{
guerry_model <- guerry
guerry_lm <- lm(Crm_prs ~ Litercy, guerry_model)
guerry_model$predictions <- predict(guerry_lm, guerry_model)

ww_global_geary_c(guerry_model, Crm_prs, predictions)
ww_global_geary_pvalue(guerry_model, Crm_prs, predictions)

wt <- ww_build_weights(guerry_model)

ww_global_geary_c_vec(
  guerry_model$Crm_prs,
  guerry_model$predictions,
  wt = wt
)
ww_global_geary_pvalue_vec(
  guerry_model$Crm_prs,
  guerry_model$predictions,
  wt = wt
)

}
\references{
Geary, R. C. (1954). "The Contiguity Ratio and Statistical Mapping". The
Incorporated Statistician. 5 (3): 115–145. doi:10.2307/2986645.

Cliff, A. D., Ord, J. K. 1981 Spatial processes, Pion, p. 17.
}
\seealso{
Other autocorrelation metrics: 
\code{\link{ww_global_moran_i}()},
\code{\link{ww_local_geary_c}()},
\code{\link{ww_local_getis_ord_g}()},
\code{\link{ww_local_moran_i}()}

Other yardstick metrics: 
\code{\link{ww_agreement_coefficient}()},
\code{\link{ww_global_moran_i}()},
\code{\link{ww_local_geary_c}()},
\code{\link{ww_local_getis_ord_g}()},
\code{\link{ww_local_moran_i}()},
\code{\link{ww_willmott_d}()}
}
\concept{autocorrelation metrics}
\concept{yardstick metrics}
