% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdi_get_sources.R
\name{wdi_get_sources}
\alias{wdi_get_sources}
\title{Download data sources from the World Bank API}
\source{
https://api.worldbank.org/v2/sources
}
\usage{
wdi_get_sources(language = "en")
}
\arguments{
\item{language}{A character string specifying the language code for the API
response (default is "en" for English).}
}
\value{
A tibble with six columns:
\describe{
\item{source_id}{An integer identifier for the data source.}
\item{source_code}{A character string for the source code.}
\item{source_name}{The name of the data source (e.g., "World Development
Indicators").}
\item{update_date}{The last update date of the data source.}
\item{is_data_available}{A boolean indicating whether data is available.}
\item{is_metadata_available}{A boolean indicating whether metadata is
available.}
\item{concepts}{The number of concepts defined for the data source.}
}
}
\description{
This function returns a tibble of supported data sources for querying the
World Bank API. The data sources include various databases and datasets
provided by the World Bank.
}
\details{
This function provides a reference for the supported data sources
and their metadata when querying the World Bank API. The columns
\code{is_data_available} and \code{is_metadata_available} are logical values
derived from the API response, where "Y" indicates availability.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download all available data sources in English
wdi_get_sources()
\dontshow{\}) # examplesIf}
}
