### Overwrite the original plot.somgrid in the class library since
### that leaves open an ugly space at the top of the plot in case of
### hexagonal grids

plot.somgrid <- function(x, type = "p", xlim, ylim, ...)
{
  ## Following two lines leave equal amounts of space on both
  ## sides of the plot if no xlim or ylim are given
  if (missing(xlim)) xlim <- c(0, max(x$pts[,1]) + min(x$pts[,1]))
  if (missing(ylim)) ylim <-  c(max(x$pts[,2]) + min(x$pts[,2]), 0)
  MASS::eqscplot(xlim, ylim,                
                 axes = FALSE, type = "n", xlab = "", ylab = "", ...)
  invisible()
}


plot.WCCSOM <-
  function(x,
           type=c("changes", "codes", "counts",
             "mapping", "property", "quality"),
           classif = x$unit.classif,    # for type="mapping", "quality"
                                        #  or "counts" 
           obj,         # for type="property"
           labels=NULL, # for type="mapping"
           pchs=NULL,   # for type="mapping"
           bgcol=heat.colors(25)[6:25], # too much red, otherwise
           zlim=NULL,
           property,        # for type="property"; default is to calculate
                            #  wcc values
           heatkey=TRUE,
           ...)
{
  type <- match.arg(type)
  ncolors <- length(bgcol)
  main <- list(...)$main

  if (type == "mapping" & is.null(labels) & is.null(pchs))
    stop("Nothing to plot: please provide either a labels or pch argument")
             
  if (type == "mapping" | type == "codes") {
    ifelse (is.null(main),
            par(mar=c(0.2,0.2,0.2,0.2)),
            par(mar=c(0.2, 0.2, 4.2, 0.2)))
  } else {
    if (type != "changes") {
      ifelse (heatkey,
              par(mar=c(2.1,4.1,4.1,2.1)),
              par(mar=c(0.6,0.6,4.1,0.6)))
    } else {
      par(mar=c(5.1, 4.1, 4.1, 2.1))
    }
  }
  
  if (!is.null(classif$classif)) # an object as generated by wccassign
    classif <- classif$classif
  if (!is.null(classif$wccs)) { # an object as generated by wccassign
    wccs <- classif$wccs
  } else {
    if (!is.null(x$wccs)) wccs <- x$wccs
  }
  
  switch(type,
         mapping = {
           plot(x$grid, ...)
           symbols(x$grid$pts[,1], x$grid$pts[,2],
                   circles=rep(.5, nrow(x$grid$pts)),
                   inches=FALSE, add=TRUE, bg="gray")
           if (is.null(labels)) {
             points(x$grid$pts[classif,1] + rnorm(length(classif), 0, .12),
                    x$grid$pts[classif,2] + rnorm(length(classif), 0, .12),
                    pch=pchs, ...)
           } else {
             text(x$grid$pts[classif,1] + rnorm(length(classif), 0, .12),
                  x$grid$pts[classif,2] + rnorm(length(classif), 0, .12),
                  labels, ...)
           }
         },
         changes = {
           plot(x$changes, type="l",
                ylab="Mean improvement in similarity",
                xlab="Epoch", ...)
         },
         counts = {
           counts <- rep(0, nrow(x$grid$pts))
           counts[as.integer(names(table(classif)))] <-
             as.integer(table(classif))
           if (is.null(zlim)) zlim <- range(counts[counts > 0])
           
           colnrs <-
             as.integer(cut(counts,
                            seq(zlim[1], zlim[2], length=ncolors+1),
                            include.lowest=TRUE))
           
           if (min(counts) == 0) {
             bgcol <- c("gray", bgcol)
             colnrs <- colnrs + 1
             colnrs[is.na(colnrs)] <- 1
           }
           
           plot(x$grid, ...)
           symbols(x$grid$pts[,1], x$grid$pts[,2],
                   circles=rep(.5, nrow(x$grid$pts)),
                   inches=FALSE, add=TRUE, fg="black",
                   bg=bgcol[colnrs])
           
         if (min(counts) == 0) bgcol <- bgcol[-1]
         },
         property = {
           addCross <- FALSE
           
           if (missing(property)) {
             codes <- x$codes
             trwdth <- x$trwdth
             property <- rep(0, ncol(codes))
             if (trwdth > 0)
               wghts <- 1 - (0:trwdth)/trwdth
             else
               wghts <- 1
             
             acor <- wac(obj, trwdth, wghts)
             for (i in 1:ncol(codes))
               property[i] <- wcc(obj, codes[,i], trwdth, wghts,
                              c(acor, x$acors[i]))

             addCross <- TRUE
           }

           plot(x$grid, ...)
           
           if (is.null(zlim))
             zlim <- range(property, finite=TRUE)
         
           symbols(x$grid$pts[,1], x$grid$pts[,2],
                   circles=rep(.5, nrow(x$grid$pts)),
                   inches=FALSE, add=TRUE, fg="black",
                   bg=bgcol[as.integer(cut(property,
                     seq(zlim[1], zlim[2], length=ncolors+1),
                     include.lowest=TRUE))])

           if (addCross) {
             whichone <- which(property == max(property, na.rm=TRUE))[1]
             segments(x$grid$pts[whichone,1]-.5, x$grid$pts[whichone,2],
                      x$grid$pts[whichone,1]+.5, x$grid$pts[whichone,2],
                      col="blue")
             segments(x$grid$pts[whichone,1], x$grid$pts[whichone,2]-.5,
                      x$grid$pts[whichone,1], x$grid$pts[whichone,2]+.5,
                      col="blue")
           }
         },
         codes = {
           plot(x$grid, ...)
           symbols(x$grid$pts[,1], x$grid$pts[,2],
                   circles=rep(.5, nrow(x$grid$pts)),
                   inches=FALSE, add=TRUE, bg="white")
           for (i in 1:nrow(x$grid$pts)) {
             lines(seq(x$grid$pts[i,1]-.4,
                       x$grid$pts[i,1]+.4,
                       length=nrow(x$codes)),
                   x$grid$pts[i,2] - .2 + x$codes[,i]*.5/max(x$codes[,i]),
                   col="red")
           }
         },
         quality = {
           nc <- ncol(x$codes)
           
           sdwccs <- wccs2 <- rep(NA, nc)
           for (i in 1:nc) {
             allis <- which(classif == i)
             if (length(allis) > 0) {
               wccs2[i] <- mean(wccs[allis])
               if (length(allis) > 1) 
                 sdwccs[i] <- sd(wccs[allis])
             }
           }
           
           if (is.null(zlim)) {
             zlim=range(wccs2, na.rm=TRUE)
#             zlim[1] <- zlim[1] * 0.98
           }
           bgcolors <- bgcol[as.integer(cut(wccs2,
                                            seq(zlim[1], zlim[2],
                                                length=ncolors+1),
                                            include.lowest=TRUE))]
           bgcolors[is.na(wccs2)] <- "gray"
           
           plot(x$grid, ...)
           symbols(x$grid$pts[,1], x$grid$pts[,2],
                   circles=rep(.5, nrow(x$grid$pts)),
                   inches=FALSE, add=TRUE, fg="black",
                   bg=bgcolors)
           sdangles <-
             pi*(sdwccs - min(sdwccs, na.rm=TRUE)) / max(sdwccs, na.rm=TRUE)
           sdangles <- sdangles - 0.5*pi
           segments(x$grid$pts[,1], x$grid$pts[,2],
                    x$grid$pts[,1] + .5*cos(sdangles),
                    x$grid$pts[,2] + .5*sin(sdangles),
                    col="blue")
         }
         )

  if (heatkey) {
    if (type == "quality" | type == "counts" | type == "property") {
      ## color legend on the left, width 4% of plotting region
      ## New code with text to the left of the heat key
      xrange <- par("usr")[1:2]
      yrange <- range(x$grid$pts[,2])
      xleft <- xrange[1] - diff(xrange)*c(.02, 0)
      yleft <- seq(yrange[1]-.5,
                   yrange[2]+.5,
                   length=ncolors+1)
      rect(xleft[1], yleft[1:ncolors],
           xleft[2], yleft[2:(ncolors+1)],
           border="black", col=bgcol, xpd=TRUE)
      zvals <- pretty(zlim)
      zvals <- zvals[zvals <= max(zlim) & zvals >= min(zlim)]
      yvals <- yrange[1] - .5 + (diff(yrange) + 1)*(zvals - zlim[1])/diff(zlim)
      text(xleft[2] - 1.3*diff(xleft),
           yvals, formatC(zvals),
           xpd=TRUE, adj=1)
    }
  }

  if (type == "property") {
    invisible(property)
  } else {
    invisible()
  }
}


