% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa_control.R
\name{+.rpacontrol}
\alias{+.rpacontrol}
\title{Add components to the control list}
\usage{
\method{+}{rpacontrol}(e1, e2)
}
\arguments{
\item{e1}{A list of class \code{rpacontrol}.}

\item{e2}{A list of class \code{rpacontrol}.}
}
\value{
A list of class \code{rpacontrol} with components from \code{e1} and
  \code{e2}.
}
\description{
`+` is used to combine components to control the PA network generation
process. Available components are \code{rpa_control_scenario()},
\code{rpa_control_edgeweight()}, \code{rpa_control_newedge()},
\code{rpa_control_preference()} and \code{rpa_control_reciprocal()}.
}
\examples{
\donttest{
control <- rpa_control_scenario(alpha = 0.5, beta = 0.5) +
    rpa_control_preference(ftype = "customized",
    spref = "pow(outs, 2) + 1",
    tpref = "pow(ins, 2) + 1")
}

control <- rpa_control_scenario(alpha = 1) +
    rpa_control_edgeweight(distribution = rgamma,
        dparams = list(shape = 5, scale = 0.2),
        shift = 1)
}
