% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{oauth2_httr_login}
\alias{oauth2_httr_login}
\title{Helper function to use httr's OAuth2.0 functions
non-interactively, e.g. in test cases}
\usage{
oauth2_httr_login(expr)
}
\arguments{
\item{expr}{Expression that calls \code{\link[httr:oauth2.0_token]{httr::oauth2.0_token()}},
either directly, or indirectly.}
}
\value{
The return value of \code{expr}.
}
\description{
To perform an automatic acknowledgement and log in for a
local OAuth2.0 app, run by httr, wrap the expression that
obtains the OAuth2.0 token in \code{oauth2_httr_login()}.
}
\details{
In interactive sessions, \code{oauth2_httr_login()} overrides the
\code{browser} option, and when httr opens a browser page, it
calls \code{\link[=oauth2_login]{oauth2_login()}} in a subprocess.

In non-interactive sessions, httr does not open a browser page,
only messages the user to do it manually. \code{oauth2_httr_login()}
listens for these messages, and calls \code{\link[=oauth2_login]{oauth2_login()}} in a
subprocess.
}
\seealso{
See \code{?vignette("oauth", package = "webfakes")} for a case
study that uses this function.

Other OAuth2.0 functions: 
\code{\link{oauth2_login}()},
\code{\link{oauth2_resource_app}()},
\code{\link{oauth2_third_party_app}()}
}
\concept{OAuth2.0 functions}
