% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{crop}
\alias{crop}
\title{Crop images and templates}
\usage{
crop(
  stimuli,
  width = 1,
  height = 1,
  x_off = NULL,
  y_off = NULL,
  fill = wm_opts("fill")
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{width, height}{dimensions of cropped image in pixels or proportion (<2)}

\item{x_off, y_off}{offset in pixels or proportion (<1) (NULL centers cropped image)}

\item{fill}{background color if cropping goes outside the original image, see \code{\link[=color_conv]{color_conv()}}}
}
\value{
list of stimuli with cropped tems and/or images
}
\description{
Remove or add margins to images and templates.
}
\details{
Dimensions and offsets can be set in pixels or proportions. For width and height, values less than 2 will be interpreted as proportions, otherwise pixels. For x_off and y_off, values between -1 and 1 are interpreted as proportions, otherwise pixels.

Cropping is anchored at the image center (or calculated template centroid if there is no image) unless x_off or y_off are set.
}
\examples{
stimuli <- demo_stim()

# crop to 60\% width and 80\% height (centered)
crop(stimuli, width = .60, height = .80)

# crop to upper right quadrant
crop(stimuli, .5, .5, x_off = .5, y_off = 0)

\donttest{
# negative offset with fill
crop(stimuli, 260, 260, 
     x_off = -10, y_off = -10, 
     fill = c("red", "dodgerblue"))
}
}
\seealso{
Stimulus manipulation functions
\code{\link{align}()},
\code{\link{crop_tem}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{resize}()},
\code{\link{rotate}()},
\code{\link{to_size}()}
}
\concept{manipulators}
