% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{create_urldummy}
\alias{create_urldummy}
\title{Create an urldummy variable from a data.table object}
\usage{
create_urldummy(wt, dummy, name)
}
\arguments{
\item{wt}{webtrack data object}

\item{dummy}{a vector of urls that should be dummy coded}

\item{name}{name of dummy variable to create.}
}
\value{
webtrack object with the same columns and a new column called "name" including the dummy variable
}
\description{
Create an urldummy variable from a data.table object
}
\examples{
data("test_data")
wt <- as.wt_dt(test_data)
wt <- extract_domain(wt)
code_urls <- c("Ccj4QELzbJe6.com/FrKrkvugBVJWwfSobV")
create_urldummy(wt,dummy = code_urls, name = "test_dummy")
}
