% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{parse_path}
\alias{parse_path}
\title{Parse parts of path for text analysis}
\usage{
parse_path(wt, varname = "url", keep = "letters_only", decode = TRUE)
}
\arguments{
\item{wt}{webtrack data object}

\item{varname}{character. name of the column from which to extract the host.
Defaults to \code{"url"}.}

\item{keep}{character. Defines which types of path components to keep.
If set to \code{"all"}, anything is kept. If \code{"letters_only"}, only parts
containing letters are kept. If \code{"words_only"}, only parts constituting
English words (as defined by the Word Game Dictionary,
cf. https://cran.r-project.org/web/packages/words/index.html) are kept.
Support for more languages will be added in future.}

\item{decode}{logical. Whether to decode the path (see \code{\link[utils:URLencode]{utils::URLdecode()}}), default to TRUE}
}
\value{
webtrack data.frame with the same columns as wt
and a new column called \code{'path_split'}  (or, if varname not equal to \code{'url'}, \code{'<varname>_path_split'})
containing parts as a comma-separated string.
}
\description{
\code{parse_path()} parses parts of a path, i.e., anything separated by
"/", "-", "_" or ".", and adds them as a new variable. Parts that do not
consist of letters only, or of a real word, can be filtered via the argument \code{keep}.
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
wt <- parse_path(wt)
}
}
