% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_prob}
\alias{predict_prob}
\title{Prediction of Failure Probabilities for Parametric Lifetime Distributions}
\usage{
predict_prob(
  q,
  dist_params,
  distribution = c("weibull", "lognormal", "loglogistic", "normal", "logistic", "sev",
    "weibull3", "lognormal3", "loglogistic3")
)
}
\arguments{
\item{q}{A numeric vector of quantiles.}

\item{dist_params}{A (named) numeric vector of (log-)location-scale parameters
in the order of location (\eqn{\mu}) and scale (\eqn{\sigma}). If a
three-parametric model is selected, the threshold parameter (\eqn{\gamma})
has to be the third element.}

\item{distribution}{Supposed distribution of the random variable.}
}
\value{
A vector with predicted (failure) probabilities.
}
\description{
This function predicts the (failure) probabilities of two- or three-parametric
lifetime distributions that belong to the (log-)location-scale family.
}
\details{
For a given set of parameters and specified quantiles the (failure) probabilities
of the chosen model are determined.
}
\examples{
# Example 1 - Predicted probabilities for a two-parameter weibull distribution:
probs_weib2 <- predict_prob(
  q = c(15, 48, 124),
  dist_params = c(5, 0.5),
  distribution = "weibull"
)

# Example 2 - Predicted quantiles for a three-parameter weibull distribution:
probs_weib3 <- predict_prob(
  q = c(25, 58, 134),
  dist_params = c(5, 0.5, 10),
  distribution = "weibull3"
)

}
