% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{wine_reviews}
\alias{wine_reviews}
\title{Wine prices and points}
\format{
A data frame with 110,203 rows and 8 columns:
\describe{
\item{country}{Country of origin}
\item{state}{State or province of origin}
\item{region}{Region of origin}
\item{winery}{Name of vineyard that made the wine}
\item{variety}{Variety of grape}
\item{points}{Points allocated by WineEnthusiast reviewer on a scale of 0-100}
\item{price}{Price of a bottle of wine in $US}
\item{year}{Year of wine extracted from \code{title}}
}
}
\source{
\url{https://kaggle.com}
}
\usage{
wine_reviews
}
\value{
Data frame
}
\description{
A data set containing data on wines from 44 countries, taken from \emph{Wine Enthusiast Magazine}
during the week of 15 June 2017.
}
\examples{
wine_reviews |>
 ggplot(aes(x = points, y = price)) +
 geom_jitter(height = 0, width = 0.2, alpha = 0.1) +
 scale_y_log10()
}
\keyword{datasets}
