% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wktview.R
\name{wktview}
\alias{wktview}
\title{Visualize geojson from a character string or list}
\usage{
wktview(x, center = NULL, zoom = 5, fmt = 16)
}
\arguments{
\item{x}{Input, a geojson character string or list}

\item{center}{(numeric) A length two vector of the form: \code{longitude, latitude}}

\item{zoom}{(integer) A number between 1 and 18 (1 zoomed out, 18 zoomed in)}

\item{fmt}{Number of digits to display after the decimal point when formatting
coordinates.}
}
\value{
Opens a map with the geojson object(s) using \code{leaflet}
}
\description{
Visualize geojson from a character string or list
}
\examples{
\dontrun{
# point
str <- "POINT (-116.4000000000000057 45.2000000000000028)"
wktview(str)

# multipoint
df <- us_cities[1:5,c('long','lat')]
str <- multipoint(df)
wktview(str)
wktview(str, center = c(-100,40))
wktview(str, zoom = 3)

# linestring
wktview(linestring(c(100.000, 0.000), c(101.000, 1.000), fmt=2))

# polygon
a <- polygon(list(c(100.001, 0.001), c(101.12345, 0.001), c(101.001, 1.001), c(100.001, 0.001)))
wktview(a)
wktview(a, zoom=9)
}
}
\seealso{
\code{\link{as_featurecollection}}
}

