% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lixn.R
\name{Lixn}
\alias{Lixn}
\title{Minta's Spatial-temporal interaction statistics}
\usage{
Lixn(traj, traj2, method = "spatial", tc = 0, hr = NULL, OZ = NULL)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes of at least two individuals. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{(optional) same as traj, but for the second group of individuals. See \code{checkTO}}

\item{method}{method for computing the marginal distribution from which expected
values are computed. If \code{method = "spatial"}, the marginal values are calculated based on areas
of the shared and unshared portions of the home ranges. If \code{method = "frequency"}, the marginal 
values are calculated based on the number of all fixes within the shared and unshared portions of 
the home ranges -- see Details.}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{hr}{(optional) spatial polygon \code{sf} object associated with the home range (or some other form of) spatial range estimate for each individual in \code{traj}. The hr polygon should have a corresponding ID column with the same column name as in \code{traj}. If NULL (the default) the MCP home range estimate will be used for each individual.}

\item{OZ}{(-- required if method = 'frequency') A \code{sf} object representing the shared area polygon associated with spatial use overlap each pair of individuals in \code{traj}. Must be a \code{sf} polygon object and contain two columns id1 and id2 indicating the polygon associated with each pair.}
}
\value{
This function returns a data.frame with values representing the calculated statistical values and associated \emph{p}-values from the Chi-squared test for each dyad.
\itemize{
\item pTable -- contingency table showing marginal probabilities of expected use 
   based on the selection of the \code{method} parameter.
\item nTable -- contingency table showing observed frequency of use of the shared 
area based on simultaneous fixes.
\item oTable -- the odds for each cell in the contingency table.
\item Laa -- the calculated value of the \eqn{L_{AA}} statistic
\item p.AA -- the associated \emph{p}-value
\item Lbb -- the calculated value of the \eqn{L_{BB}} statistic
\item p.BB -- the associated \emph{p}-value
\item Lixn -- the calculated value of the \eqn{L_{ixn}} statistic
\item p.IXN -- the associated \emph{p}-value
}
}
\description{
The function \code{Lixn} measures dynamic interaction between two animals following
the methods outlined by Minta (1992).
}
\details{
The function \code{Lixn} can be used to calculate the Minta (1992) measures of dynamic
interaction between two animals. The Minta statistic tests how the two animals simultaneously utilize
an area shared between the two individuals. Three coefficients are produced \eqn{L_{AA}}, \eqn{L_{BB}}, 
and \eqn{L_{ixn}}. Each of these statistics are based on a contingency table that compares the observed 
frequency of those fixes that are simultaneous and within/outside the shared area to expectations based on 
area overlap proportions (if \code{method="spatial"}) or expectations derived from all fixes (if 
\code{method="frequency"}) -- see Minta (1992) for more details. A Chi-squared statistic can then
be used to examine the significance between the observed and expected use of the shared area.
\cr\cr
Minta (1992) suggests the following interpretations of the coefficients. When \eqn{L_{AA}}
is near 0, the first animal's use of the shared area is random (or as expected). When
\eqn{L_{AA} > 0} it signifies spatial attraction to the shared area, or greater than
expected use. When \eqn{L_{AA} < 0} it signifies spatial avoidance of the shared area, or
less than expected use. Interpretation of \eqn{L_{BB}} is the same as for \eqn{L_{AA}} with
respect to the second animal. \eqn{L_{ixn}} tells us far more about the nature of the
interaction between the two individuals. As \eqn{L_{ixn}} nears 0, both animals use the
shared area randomly, with regards to the other animal. If \eqn{L_{ixn} > 0} the animals
use the shared area more \emph{simultaneously}, whereas if \eqn{L_{ixn} < 0} it is an
indication of \emph{solitary} use, or avoidance. This is why \eqn{L_{ixn}} is termed the temporal
interaction coefficient. A Chi-squared test can be used to identify the significance
of the \eqn{L_{AA}}, \eqn{L_{BB}}, and \eqn{L_{ixn}} values.
\cr\cr
NOTEs: 
\cr
1. With modern telemetry datasets, where home ranges are readily estimated, choosing \code{method = 'spatial'}
is most appropriate. If parmater \code{hr} is not specified, the code uses the minimum convex hull method to calculate individual 
home ranges.
\cr
2. When the home ranges do not overlap the Lixn statistic is not defined and the function returns a 
string of NA's.
\cr
3. When one home range completely encloses another the Lixn statistic is not defined and the function returns
a string of NA's and \code{'ContainsB'} (or \code{'ContainsB'}) under the p.IXN result.
\cr
4. Further to points 2 and 3, the Lixn statistic is not appropriate in situations where the overlap area is 
either very large or very small relative to either home range (i.e., a situation with almost complete enclosure 
or virtually no overlap). The example data (deer) is an exampl of a near complete enclosure. Thus, it is advised 
that \code{Lixn} be used only in situations where there are suitable marginal areas for areaA, areaB, and areaAB 
-- see Minta (1992).
}
\examples{
\dontrun{
data(deer)
#tc = 7.5 minutes, dc = 50 meters
Lixn(deer,  method='spatial', tc=7.5*60)

#use internal buffer 500m of MCP for demonstration of frequency method
# NOTE: This is just an example, this is not an appropriate way to define overlap zone.
idcol <- mt_track_id_column(deer)
deercore <- deer |>
  st_union() |>
  st_convex_hull() |>
  st_buffer(-500)
Lixn(deer,  method='frequency', tc=7.5*60, OZ=deercore)
}
}
\references{
Minta, S.C. (1992) Tests of spatial and temporal interaction among animals.
\emph{Ecological Applications}, \bold{2}: 178-188
}
\seealso{
GetSimultaneous
}
\keyword{indices}
