% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwolf.R
\name{rwolf}
\alias{rwolf}
\title{Romano-Wolf multiple hypotheses adjusted p-values}
\usage{
rwolf(
  models,
  param,
  B,
  R = NULL,
  r = 0,
  p_val_type = "two-tailed",
  weights_type = "rademacher",
  engine = "R",
  nthreads = 1,
  bootstrap_type = "fnw11",
  ...
)
}
\arguments{
\item{models}{An object of type `fixest_multi` or a list of objects of 
type `fixest`, estimated via ordinary least squares (OLS)}

\item{param}{The regression parameter to be tested}

\item{B}{The number of bootstrap iterations}

\item{R}{Hypothesis Vector giving linear combinations of coefficients.
Must be either NULL or a vector of the same length as `param`. 
If NULL, a vector of ones of length param.}

\item{r}{A numeric. Shifts the null hypothesis 
H0: `param.` = r vs H1: `param.` != r}

\item{p_val_type}{Character vector of length 1. Type of hypothesis test 
By default "two-tailed". Other options include "equal-tailed"
 (for one-sided tests), ">" and "<" (for two-sided tests).}

\item{weights_type}{character or function. The character string specifies 
the type of bootstrap to use: One of "rademacher", "mammen", "norm"
and "webb". Alternatively, type can be a function(n) for drawing 
wild bootstrap factors. "rademacher" by default.  For the Rademacher 
distribution, if the number of replications B exceeds the number of possible
draw ombinations, 2^(#number of clusters), then `boottest()` will use each 
possible combination once (enumeration).}

\item{engine}{Should the wild cluster bootstrap run via `fwildclusterboot's`
R implementation or via `WildBootTests.jl`? 'R' by default. 
The other option is `WildBootTests.jl`. Running the bootstrap through 
`WildBootTests.jl` might significantly reduce the runtime of `rwolf()` 
for complex problems (e.g. problems with more than 500 clusters).}

\item{nthreads}{Integer. The number of threads to use when running the 
bootstrap.}

\item{bootstrap_type}{Either "11", "13", "31", "33", or "fnw11". 
"fnw11" by default. See `?fwildclusterboot::boottest` for more details}

\item{...}{additional function values passed to the bootstrap function.}
}
\value{
A data.frame containing the following columns: 
\item{model}{Index of Models}
\item{Estimate}{The estimated coefficient of `param` in the respective model.}
\item{Std. Error}{The estimated standard error of `param` in the respective model.}
\item{t value}{The t statistic of `param` in the respective model.}
\item{Pr(>|t|)}{The uncorrected pvalue for `param` in the respective model.}
\item{RW Pr(>|t|)}{The Romano-Wolf corrected pvalue of hypothesis test for `param` in the respective model.}
}
\description{
Function implements the Romano-Wolf multiple hypothesis correction procedure
for objects of type `fixest_multi` (`fixest_multi` are objects created by 
`fixest::feols()` that use `feols()` multiple-estimation interface).  
The null hypothesis is always imposed on the bootstrap dgp.
}
\section{Setting Seeds and Random Number Generation}{


To guarantee reproducibility, please set a global random seeds via
`set.seed()`.
}

\examples{
 
library(fixest)
library(wildrwolf)

set.seed(12345)

N <- 1000
X1 <- rnorm(N)
Y1 <- 1 + 1 * X1 + rnorm(N)
Y2 <- 1 + 0.01 * X1 + rnorm(N)
Y3 <- 1 + 0.01 * X1 + rnorm(N)
Y4 <- 1 + 0.01 * X1 + rnorm(N)

B <- 999
# intra-cluster correlation of 0 for all clusters
cluster <- rep(1:50, N / 50)

data <- data.frame(Y1 = Y1, 
                   Y2 = Y2, 
                   Y3 = Y3, 
                   Y4 = Y4,
                   X1 = X1, 
                   cluster = cluster)

res <- feols(c(Y1, Y2, Y3) ~ X1, data = data, cluster = ~ cluster)
res_rwolf <- rwolf(models = res, param = "X1", B = B)
res_rwolf

}
\references{
Clarke, Romano & Wolf (2019), STATA Journal. 
IZA working paper: https://ftp.iza.org/dp12845.pdf
}
